/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.services.impl;

import cat.albirar.communications.core.configuration.AlbirarCommunicationsConfiguration;
import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.services.ICommunicationService;
import cat.albirar.communications.core.status.EStatusMessage;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import cat.albirar.communications.test.RabbitMqContainerExtension;
import cat.albirar.communications.test.configuration.TestMessagesFactory;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.StringUtils;

@ContextConfiguration(classes={AlbirarCommunicationsConfiguration.class})
@ExtendWith(value={SpringExtension.class, RabbitMqContainerExtension.class})
public class NoProvidersTest {
    @Autowired
    private ICommunicationService communicationService;
    private MessageBean emailMessage;
    private MessageBean smsMessage;
    @SpyBean
    private RabbitOperations rabbitTemplate;

    @BeforeEach
    public void init() {
        TestMessagesFactory tm = new TestMessagesFactory();
        this.emailMessage = tm.getEmailMessage();
        this.smsMessage = tm.getSmsMessage();
    }

    @Test
    public void testSendEmailWithoutProviderTest() {
        ((RabbitOperations)Mockito.doCallRealMethod().when((Object)this.rabbitTemplate)).send(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Message)ArgumentMatchers.any(Message.class), (CorrelationData)ArgumentMatchers.any(CorrelationData.class));
        String messageId = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.communicationService.isStatusMessage(messageId));
        Optional oSt = this.communicationService.popStatusMessage(messageId);
        Assertions.assertNotNull((Object)oSt);
        Assertions.assertTrue((boolean)oSt.isPresent());
        MessageStatusBean st = (MessageStatusBean)oSt.get();
        Assertions.assertEquals((Object)EStatusMessage.ERROR, (Object)st.getStatus());
        Assertions.assertNotNull((Object)st.getErrorMessage());
        Assertions.assertTrue((boolean)st.getErrorMessage().isPresent());
        Assertions.assertTrue((boolean)StringUtils.hasText((String)((String)st.getErrorMessage().get())));
    }

    @Test
    public void testSendSmsWithoutProviderTest() {
        ((RabbitOperations)Mockito.doCallRealMethod().when((Object)this.rabbitTemplate)).send(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Message)ArgumentMatchers.any(Message.class), (CorrelationData)ArgumentMatchers.any(CorrelationData.class));
        String messageId = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.communicationService.isStatusMessage(messageId));
        Optional oSt = this.communicationService.popStatusMessage(messageId);
        Assertions.assertNotNull((Object)oSt);
        Assertions.assertTrue((boolean)oSt.isPresent());
        MessageStatusBean st = (MessageStatusBean)oSt.get();
        Assertions.assertEquals((Object)EStatusMessage.ERROR, (Object)st.getStatus());
        Assertions.assertNotNull((Object)st.getErrorMessage());
        Assertions.assertTrue((boolean)st.getErrorMessage().isPresent());
        Assertions.assertTrue((boolean)StringUtils.hasText((String)((String)st.getErrorMessage().get())));
    }
}

