/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.services.impl;

import cat.albirar.communications.core.channels.models.ContactBean;
import cat.albirar.communications.core.channels.models.ECommunicationChannelType;
import cat.albirar.communications.core.channels.models.LocalizableAttributesCommunicationChannelBean;
import cat.albirar.communications.core.configuration.AlbirarCommunicationsConfiguration;
import cat.albirar.communications.core.services.IReportRegister;
import cat.albirar.communications.core.status.EStatusMessage;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import cat.albirar.template.engine.EContentType;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Optional;
import javax.validation.ConstraintViolationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ContextConfiguration(classes={AlbirarCommunicationsConfiguration.class})
@ExtendWith(value={SpringExtension.class})
@Execution(value=ExecutionMode.CONCURRENT)
public class ReportRegisterTest {
    @Autowired
    private IReportRegister reportRegister;
    private static final String ID_COLLECTION = "collection";
    private SecureRandom secureRandom = new SecureRandom();
    private MessageStatusBean model = ((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)MessageStatusBean.builder().body("TEST-BODY")).bodyCharSet(Charset.defaultCharset())).bodyType(EContentType.TEXT_PLAIN)).receiver(ContactBean.builder().channelBean(((LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder)((LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder)LocalizableAttributesCommunicationChannelBean.builder().channelId("receiver@server.com")).channelType(ECommunicationChannelType.EMAIL)).locale(Locale.getDefault()).build()).displayName("TEST-RECEIVER").preferredLocale(Locale.getDefault()).build())).sender(ContactBean.builder().channelBean(((LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder)((LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder)LocalizableAttributesCommunicationChannelBean.builder().channelId("sender@server.com")).channelType(ECommunicationChannelType.EMAIL)).locale(Locale.getDefault()).build()).displayName("TEST-SENDER").preferredLocale(Locale.getDefault()).build())).title("TEST-TITLE")).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateRandomId() {
        SecureRandom secureRandom = this.secureRandom;
        synchronized (secureRandom) {
            return this.secureRandom.ints(10L, 48, 122).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        }
    }

    @Test
    public void testValidations() {
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.getAndDeleteReport(null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.getAndDeleteReport(""));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.getAndDeleteReport("  "));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.getReport(null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.getReport(""));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.getReport("  "));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.isReport(null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.isReport(""));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.isReport("  "));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport(null, null, null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport("", null, null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport("  ", null, null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport(ID_COLLECTION, null, null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport(ID_COLLECTION, "", null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport(ID_COLLECTION, "  ", null));
        String msgId = this.generateRandomId();
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport(ID_COLLECTION, msgId, null));
        MessageStatusBean ms = MessageStatusBean.builder().build();
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.putReport(ID_COLLECTION, msgId, ms));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.removeReport(null, null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.removeReport("", null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.removeReport("  ", null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.removeReport(ID_COLLECTION, null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.removeReport(ID_COLLECTION, ""));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.reportRegister.removeReport(ID_COLLECTION, "  "));
    }

    @RepeatedTest(value=100)
    public void testGetAndDeleteReportSend() {
        Optional om = this.reportRegister.getAndDeleteReport("XXX");
        Assertions.assertFalse((boolean)om.isPresent());
        MessageStatusBean m = this.model.toBuilder().messageId(this.generateRandomId()).status(EStatusMessage.SEND).build();
        this.reportRegister.putReport(ID_COLLECTION, m.getMessageId(), m);
        om = this.reportRegister.getAndDeleteReport(m.getMessageId());
        Assertions.assertTrue((boolean)om.isPresent());
        MessageStatusBean m1 = (MessageStatusBean)om.get();
        Assertions.assertSame((Object)m, (Object)m1);
        Assertions.assertFalse((boolean)this.reportRegister.isReport(m.getMessageId()));
    }

    @RepeatedTest(value=100)
    public void testPutAndRemoveReport() {
        Optional om = this.reportRegister.removeReport(ID_COLLECTION, "XXX");
        Assertions.assertFalse((boolean)om.isPresent());
        MessageStatusBean m = this.model.toBuilder().messageId(this.generateRandomId()).status(EStatusMessage.SEND).build();
        this.reportRegister.putReport(ID_COLLECTION, m.getMessageId(), m);
        om = this.reportRegister.removeReport(ID_COLLECTION, "XXX");
        Assertions.assertFalse((boolean)om.isPresent());
        om = this.reportRegister.removeReport(ID_COLLECTION, m.getMessageId());
        Assertions.assertTrue((boolean)om.isPresent());
        MessageStatusBean m1 = (MessageStatusBean)om.get();
        Assertions.assertEquals((Object)m, (Object)m1);
        Assertions.assertFalse((boolean)this.reportRegister.isReport(m.getMessageId()));
    }

    @RepeatedTest(value=100)
    public void testIsReport() {
        Assertions.assertFalse((boolean)this.reportRegister.isReport(this.generateRandomId()));
        MessageStatusBean m = this.model.toBuilder().messageId(this.generateRandomId()).status(EStatusMessage.SEND).build();
        this.reportRegister.putReport(ID_COLLECTION, m.getMessageId(), m);
        Assertions.assertTrue((boolean)this.reportRegister.isReport(m.getMessageId()));
        Assertions.assertFalse((boolean)this.reportRegister.isReport(this.generateRandomId()));
    }

    @RepeatedTest(value=100)
    public void testGetReport() {
        Optional om = this.reportRegister.getReport("XXX");
        Assertions.assertFalse((boolean)om.isPresent());
        MessageStatusBean m = this.model.toBuilder().messageId(this.generateRandomId()).status(EStatusMessage.SEND).build();
        this.reportRegister.putReport(ID_COLLECTION, m.getMessageId(), m);
        om = this.reportRegister.getReport(m.getMessageId());
        Assertions.assertTrue((boolean)om.isPresent());
        Assertions.assertSame((Object)m, om.get());
    }
}

