/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.test;

import java.util.concurrent.Semaphore;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.RabbitMQContainer;

public class RabbitMqContainerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqContainerExtension.class);
    private static RabbitMQContainer container = null;
    private Semaphore semaphore = new Semaphore(1, true);

    public void beforeAll(ExtensionContext context) throws Exception {
        try {
            this.semaphore.acquire();
            LOGGER.info("Start RabbitMQ test container albirar extension...");
            if (container == null) {
                container = new RabbitMQContainer();
            } else if (container.isRunning()) {
                container.stop();
            }
            container.start();
            LOGGER.info("RabbitMQ test container albirar extension started");
            System.setProperty("albirar.communications.connection.host", container.getHost());
            System.setProperty("albirar.communications.connection.port", container.getAmqpPort().toString());
            System.setProperty("albirar.communications.connection.username", container.getAdminUsername());
            System.setProperty("albirar.communications.connection.password", container.getAdminPassword());
        }
        finally {
            this.semaphore.release();
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        block6: {
            LOGGER.info("End RabbitMQ test container albirar extension...");
            try {
                this.semaphore.acquire();
                if (container == null || !container.isRunning()) break block6;
                LOGGER.info("Stopping RabbitMQ test container albirar extension...");
                try {
                    container.stop();
                    LOGGER.info("RabbitMQ test container albirar extension stopped");
                }
                finally {
                    container = null;
                }
            }
            finally {
                this.semaphore.release();
            }
        }
    }
}

