/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.core.processors.impl;

import cat.albirar.communications.core.processors.IProcessor;
import cat.albirar.communications.core.services.IReportRegister;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractReportProcessor
implements IProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReportProcessor.class);
    @Autowired
    protected MessageConverter converter;
    @Autowired
    protected IReportRegister reportRegister;
    private AtomicLong processedMessages = new AtomicLong(0L);
    private AtomicLong managedMessages = new AtomicLong(0L);

    @Override
    public long getManagedMessages() {
        return this.managedMessages.get();
    }

    @Override
    public long getProcessedMessages() {
        return this.processedMessages.get();
    }

    public void onMessage(Message message) {
        LOGGER.debug("Processing report {}", (Object)message);
        this.managedMessages.incrementAndGet();
        try {
            Object o = this.converter.fromMessage(message);
            try {
                MessageStatusBean r = (MessageStatusBean)o;
                this.processReport(r);
                this.processedMessages.incrementAndGet();
            }
            catch (ClassCastException e) {
                LOGGER.error("The single amqp status message of class {} is not assignable to class {}", o.getClass(), MessageStatusBean.class);
            }
        }
        catch (MessageConversionException e) {
            LOGGER.error(String.format("Unknow error %s converting amqp status message %s", e.getMessage(), message), (Throwable)e);
        }
    }

    protected abstract void processReport(MessageStatusBean var1);
}

