/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.core.processors.impl;

import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.processors.IProcessor;
import cat.albirar.communications.core.services.ServiceException;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.NamingStrategy;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSenderProcessor
implements IProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSenderProcessor.class);
    @Autowired
    protected MessageConverter converter;
    @Autowired
    protected RabbitOperations rabbitTemplate;
    @Autowired
    private NamingStrategy namingStrategy;
    protected String exchangeName = "albirar-communications";
    private AtomicLong processedMessages = new AtomicLong(0L);
    private AtomicLong managedMessages = new AtomicLong(0L);

    public void onMessage(Message message) {
        LOGGER.info("Processing single amqp message {}", (Object)message);
        this.managedMessages.incrementAndGet();
        try {
            Object o = this.converter.fromMessage(message);
            try {
                MessageBean msg = (MessageBean)o;
                this.processMessage(message.getMessageProperties().getMessageId(), msg);
                this.processedMessages.incrementAndGet();
                LOGGER.info("End of processing single amqp message {}", (Object)message);
            }
            catch (ClassCastException e) {
                LOGGER.error("The single amqp message of class {} is not assignable to class {}", o.getClass(), MessageBean.class);
            }
            catch (ServiceException e) {
                LOGGER.error(String.format("On processing message %s", message), (Throwable)e);
            }
        }
        catch (MessageConversionException e) {
            LOGGER.error(String.format("Unknow error converting amqp message %s", message), (Throwable)e);
        }
    }

    @Override
    public long getManagedMessages() {
        return this.managedMessages.get();
    }

    @Override
    public long getProcessedMessages() {
        return this.processedMessages.get();
    }

    protected abstract void processMessage(String var1, MessageBean var2);

    protected void reportMessage(String queueName, MessageStatusBean message) {
        LOGGER.debug("Report on {} the message with id {} ({})", new Object[]{queueName, message.getMessageId(), message});
        CorrelationData crlt = new CorrelationData(message.getMessageId());
        try {
            MessageProperties msgProps = new MessageProperties();
            msgProps.setCorrelationId(message.getMessageId());
            msgProps.setMessageId(this.namingStrategy.generateName());
            Message msg = this.converter.toMessage((Object)message, msgProps);
            this.rabbitTemplate.send(this.exchangeName, queueName, msg);
            LOGGER.debug("Message {} reported on {} with id {}!", new Object[]{message, queueName, crlt.getId()});
        }
        catch (MessageConversionException e) {
            String s = String.format("Error converting status message %s to AMQP message to exchange %s and queue %s", message, this.exchangeName, queueName);
            LOGGER.error(s, (Throwable)e);
            throw new ServiceException(s, e);
        }
        catch (AmqpException e) {
            String s = String.format("Error on send the message %s to exchange %s and queue %s", message, this.exchangeName, queueName);
            LOGGER.error(s, (Throwable)e);
            throw new ServiceException(s, e);
        }
    }
}

