/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.core.services.impl;

import cat.albirar.communications.core.channels.models.ECommunicationChannelType;
import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.services.ICommunicationService;
import cat.albirar.communications.core.services.IReportRegister;
import cat.albirar.communications.core.services.ServiceException;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.NamingStrategy;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommunicationServiceImpl
implements ICommunicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommunicationServiceImpl.class);
    @Autowired
    private RabbitOperations rabbitTemplate;
    @Autowired
    private MessageConverter messageConverter;
    @Autowired
    private NamingStrategy namingStrategy;
    @Autowired
    private IReportRegister reportRegister;
    private String exchangeName = "albirar-communications";
    private String emailSendQueueName = "emailSendQueue";
    private String smsSendQueueName = "smsSendQueue";

    @Override
    public Optional<MessageStatusBean> popStatusMessage(String messageId) {
        return this.reportRegister.getAndDeleteReport(messageId);
    }

    @Override
    public boolean isStatusMessage(String messageId) {
        return this.reportRegister.isReport(messageId);
    }

    @Override
    public String pushMessage(MessageBean message) {
        LOGGER.debug("Pushing message {}...", (Object)message);
        CorrelationData crlt = this.createCorrelationData();
        String rKey = message.getReceiver().getChannelBean().getChannelType() == ECommunicationChannelType.EMAIL ? this.emailSendQueueName : this.smsSendQueueName;
        try {
            MessageProperties mp = new MessageProperties();
            mp.setMessageId(crlt.getId());
            Message msg = this.messageConverter.toMessage((Object)message, mp);
            this.rabbitTemplate.send(this.exchangeName, rKey, msg, crlt);
            LOGGER.debug("Message ({}) pushed onto {} with id {}", new Object[]{message, rKey, crlt.getId()});
            return crlt.getId();
        }
        catch (MessageConversionException e) {
            String s = String.format("Error converting message %s to AMQP message with %s destination", message, rKey);
            LOGGER.error(s, (Throwable)e);
            throw new ServiceException(s, e);
        }
        catch (AmqpException e) {
            String s = String.format("Cannot push message %s onto %s", message, rKey);
            LOGGER.error(s, (Throwable)e);
            throw new ServiceException(s, e);
        }
    }

    private CorrelationData createCorrelationData() {
        return new CorrelationData(this.namingStrategy.generateName());
    }
}

