/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.core.services.impl;

import cat.albirar.communications.core.services.IReportRegister;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
public class ReportRegister
implements IReportRegister {
    private ConcurrentMap<String, ConcurrentMap<String, MessageStatusBean>> reports = new ConcurrentHashMap<String, ConcurrentMap<String, MessageStatusBean>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<MessageStatusBean> getReport(String messageId) {
        ConcurrentMap<String, ConcurrentMap<String, MessageStatusBean>> concurrentMap = this.reports;
        synchronized (concurrentMap) {
            for (String collectionId : this.reports.keySet()) {
                if (!((ConcurrentMap)this.reports.get(collectionId)).containsKey(messageId)) continue;
                return Optional.of(((ConcurrentMap)this.reports.get(collectionId)).get(messageId));
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<MessageStatusBean> getAndDeleteReport(String messageId) {
        ConcurrentMap<String, ConcurrentMap<String, MessageStatusBean>> concurrentMap = this.reports;
        synchronized (concurrentMap) {
            for (String collectionId : this.reports.keySet()) {
                if (!((ConcurrentMap)this.reports.get(collectionId)).containsKey(messageId)) continue;
                return this.removeReport(collectionId, messageId);
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReport(String messageId) {
        ConcurrentMap<String, ConcurrentMap<String, MessageStatusBean>> concurrentMap = this.reports;
        synchronized (concurrentMap) {
            for (String collectionId : this.reports.keySet()) {
                if (!((ConcurrentMap)this.reports.get(collectionId)).containsKey(messageId)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putReport(String collectionId, String messageId, MessageStatusBean report) {
        ConcurrentMap<String, ConcurrentMap<String, MessageStatusBean>> concurrentMap = this.reports;
        synchronized (concurrentMap) {
            if (!this.reports.containsKey(collectionId)) {
                this.reports.put(collectionId, new ConcurrentHashMap());
            }
            ConcurrentMap collection = (ConcurrentMap)this.reports.get(collectionId);
            collection.put(messageId, report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<MessageStatusBean> removeReport(String collectionId, String messageId) {
        ConcurrentMap<String, ConcurrentMap<String, MessageStatusBean>> concurrentMap = this.reports;
        synchronized (concurrentMap) {
            if (this.reports.containsKey(collectionId)) {
                return Optional.ofNullable(((ConcurrentMap)this.reports.get(collectionId)).remove(messageId));
            }
            return Optional.empty();
        }
    }
}

