/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.providers.mocks;

import cat.albirar.communications.providers.email.RootPushBean;
import cat.albirar.communications.providers.mocks.IMockServiceProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotBlank;

public abstract class AbstractMockServiceProvider<T extends RootPushBean>
implements IMockServiceProvider<T> {
    protected Map<String, T> pushedMessages;
    protected boolean throwException = false;
    protected Map<String, T> throwMessages;

    @PostConstruct
    public void init() {
        this.pushedMessages = new HashMap<String, T>();
        this.throwMessages = new HashMap<String, T>();
        this.throwException = false;
    }

    @Override
    public boolean isThrowException() {
        return this.throwException;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMessageProcessed(String messageId) {
        Map<String, T> map = this.pushedMessages;
        synchronized (map) {
            return this.pushedMessages.containsKey(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThrowMessageProcessed(@NotBlank String messageId) {
        Map<String, T> map = this.throwMessages;
        synchronized (map) {
            return this.throwMessages.containsKey(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<T> getMessage(String messageId) {
        Map<String, T> map = this.pushedMessages;
        synchronized (map) {
            return Optional.ofNullable(this.pushedMessages.get(messageId));
        }
    }
}

