/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.services.impl;

import cat.albirar.communications.core.configuration.AlbirarCommunicationsConfiguration;
import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.processors.impl.EmailReportProcessor;
import cat.albirar.communications.core.processors.impl.EmailSenderProcessor;
import cat.albirar.communications.core.processors.impl.SmsReportProcessor;
import cat.albirar.communications.core.processors.impl.SmsSenderProcessor;
import cat.albirar.communications.core.services.ICommunicationService;
import cat.albirar.communications.core.services.ServiceException;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import cat.albirar.communications.test.RabbitMqContainerExtension;
import cat.albirar.communications.test.configuration.CoreCommunicationsTestConfiguration;
import cat.albirar.communications.test.configuration.TestMessagesFactory;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ContextConfiguration(classes={AlbirarCommunicationsConfiguration.class, CoreCommunicationsTestConfiguration.class})
@ExtendWith(value={SpringExtension.class, RabbitMqContainerExtension.class, MockitoExtension.class})
public class SenderAndReportTest {
    @Autowired
    private ICommunicationService communicationService;
    @SpyBean
    private MessageConverter messageConverter;
    @SpyBean
    private RabbitOperations rabbitTemplate;
    @Autowired
    private EmailReportProcessor emailReportProcessor;
    @Autowired
    private SmsReportProcessor smsReportProcessor;
    @Autowired
    private EmailSenderProcessor emailSenderProcessor;
    @Autowired
    private SmsSenderProcessor smsSenderProcessor;
    private MessageBean emailMessage;
    private MessageBean smsMessage;

    @BeforeEach
    public void init() {
        TestMessagesFactory tm = new TestMessagesFactory();
        this.emailMessage = tm.getEmailMessage();
        this.smsMessage = tm.getSmsMessage();
    }

    @Test
    public void testEmailSenderManagedProcessedMessages() {
        long lSm = this.emailSenderProcessor.getManagedMessages();
        long lSp = this.emailSenderProcessor.getProcessedMessages();
        long lRm = this.emailReportProcessor.getManagedMessages();
        long lRp = this.emailReportProcessor.getProcessedMessages();
        String id = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.communicationService.isStatusMessage(id));
        Assertions.assertTrue((this.emailSenderProcessor.getManagedMessages() > lSm ? 1 : 0) != 0);
        Assertions.assertTrue((this.emailSenderProcessor.getProcessedMessages() > lSp ? 1 : 0) != 0);
        Assertions.assertTrue((this.emailReportProcessor.getManagedMessages() > lRm ? 1 : 0) != 0);
        Assertions.assertTrue((this.emailReportProcessor.getProcessedMessages() > lRp ? 1 : 0) != 0);
    }

    @Test
    public void testEmailPushMessageConverterException() {
        ((MessageConverter)Mockito.doThrow(MessageConversionException.class).when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ServiceException ex = (ServiceException)Assertions.assertThrows(ServiceException.class, () -> this.communicationService.pushMessage(this.emailMessage));
        Assertions.assertNotNull((Object)ex.getCause());
        Assertions.assertEquals(MessageConversionException.class, ex.getCause().getClass());
    }

    @Test
    public void testEmailSenderOnMessageMessageConverterException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doThrow(MessageConversionException.class).when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.emailSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.emailSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testEmailSenderOnMessageClassCastException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doReturn((Object)"Test").when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.emailSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.emailSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testEmailPushReportAmqpException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(Mockito.any(MessageBean.class), (MessageProperties)Mockito.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        ((RabbitOperations)Mockito.doThrow(AmqpException.class).when((Object)this.rabbitTemplate)).send((String)ArgumentMatchers.eq((Object)"albirar-communications"), (String)ArgumentMatchers.eq((Object)"emailReportQueue"), (Message)ArgumentMatchers.any(Message.class));
        long l = this.emailSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.emailSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testEmailPushReportMessageConverterException() {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.eq((Object)this.emailMessage), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        ((MessageConverter)Mockito.doThrow(MessageConversionException.class).when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageStatusBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        long l = this.emailSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.emailSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testEmailReportOnMessageMessageConverterException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().doThrow(MessageConversionException.class).when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.emailReportProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.emailReportProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testEmailReportOnMessageClassCastException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().doReturn((Object)"Test").when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.emailReportProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.emailReportProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testSmsPushMessageConverterException() {
        ((MessageConverter)Mockito.doThrow(MessageConversionException.class).when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ServiceException ex = (ServiceException)Assertions.assertThrows(ServiceException.class, () -> this.communicationService.pushMessage(this.smsMessage));
        Assertions.assertNotNull((Object)ex.getCause());
        Assertions.assertEquals(MessageConversionException.class, ex.getCause().getClass());
    }

    @Test
    public void testSmsSenderOnMessageMessageConverterException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doThrow(MessageConversionException.class).when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.smsSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testSmsSenderOnMessageClassCastException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doReturn((Object)"Test").when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.smsSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testSmsPushReportAmqpException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        ((RabbitOperations)Mockito.doThrow(AmqpException.class).when((Object)this.rabbitTemplate)).send((String)ArgumentMatchers.eq((Object)"albirar-communications"), (String)ArgumentMatchers.eq((Object)"smsReportQueue"), (Message)ArgumentMatchers.any(Message.class));
        long l = this.smsSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testSmsPushReportMessageConverterException() {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.eq((Object)this.smsMessage), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        ((MessageConverter)Mockito.doThrow(MessageConversionException.class).when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageStatusBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        long l = this.smsSenderProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsSenderProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testSmsReportOnMessageReportMessageConverterException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().doThrow(MessageConversionException.class).when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.smsReportProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsReportProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }

    @Test
    public void testSmsReportOnMessageReportClassCastException() throws Exception {
        ((MessageConverter)Mockito.doCallRealMethod().when((Object)this.messageConverter)).toMessage(ArgumentMatchers.any(MessageBean.class), (MessageProperties)ArgumentMatchers.any(MessageProperties.class));
        ((MessageConverter)Mockito.doCallRealMethod().doReturn((Object)"Test").when((Object)this.messageConverter)).fromMessage((Message)ArgumentMatchers.any(Message.class));
        long l = this.smsReportProcessor.getManagedMessages();
        String id = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsReportProcessor.getManagedMessages() > l);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(id));
    }
}

