/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.core.processors.impl;

import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.processors.impl.AbstractSenderProcessor;
import cat.albirar.communications.core.providers.ProviderException;
import cat.albirar.communications.core.providers.email.IEmailProvider;
import cat.albirar.communications.core.status.EStatusMessage;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EmailSenderProcessor
extends AbstractSenderProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailSenderProcessor.class);
    @Autowired(required=false)
    private List<IEmailProvider> emailProviders;

    @Override
    protected void processMessage(String messageId, MessageBean message) {
        LOGGER.debug("Sending email for message {}", (Object)message);
        try {
            if (!CollectionUtils.isEmpty(this.emailProviders)) {
                this.emailProviders.get(0).sendEmail(messageId, message.getSender(), message.getReceiver(), message.getTitle(), message.getBody(), message.getBodyType().getMediaType(), message.getBodyCharSet().name());
                MessageBean r = ((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)MessageStatusBean.copyBuilder(message).status(EStatusMessage.SEND)).messageId(messageId)).build();
                this.reportMessage("emailReportQueue", (MessageStatusBean)r);
            } else {
                LOGGER.error("No email provider was configured!");
                MessageBean r = ((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)MessageStatusBean.copyBuilder(message).status(EStatusMessage.ERROR)).messageId(messageId)).errorMessage(Optional.of("No email provider was configured!"))).build();
                this.reportMessage("emailReportQueue", (MessageStatusBean)r);
            }
        }
        catch (ProviderException e) {
            String errMsg = String.format("On preparing or sending the mail message for %s (%s)", message, e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            MessageBean r = ((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)MessageStatusBean.copyBuilder(message).status(EStatusMessage.ERROR)).messageId(messageId)).errorMessage(Optional.of(errMsg))).build();
            this.reportMessage("emailReportQueue", (MessageStatusBean)r);
        }
    }
}

