// Generated by delombok at Thu Jan 21 20:42:03 CET 2021
/*
 * This file is part of "albirar albirar-template-engine".
 * 
 * "albirar albirar-template-engine" is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * "albirar albirar-template-engine" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "albirar albirar-template-engine" source code.  If not, see <https://www.gnu.org/licenses/gpl-3.0.html>.
 *
 * Copyright (C) 2020 Octavi Fornés
 */
package cat.albirar.template.engine.models;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.validation.constraints.NotNull;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import lombok.Builder.Default;

/**
 * The template definition with variables, messages and locale ready to render.
 * @author Octavi Forn&eacute;s &lt;<a href="mailto:ofornes@albirar.cat">ofornes@albirar.cat</a>&gt;
 * @since 1.0.0
 */
public class TemplateInstanceBean extends TemplateDefinitionBean {
    private static final long serialVersionUID = -5629519913709919500L;
    @NotNull
    private MessageSource messages;
    @NotNull
    private Map<String, Object> variables;
    @NotNull
    private Locale locale;

    /**
     * Build an instance with {@link Locale#getDefault()} and without {@link TemplateInstanceBean#getMessages()} and an empty {@link TemplateInstanceBean#getVariables()}. 
     * @param definition The template definition
     * @param locale The locale
     * @return The instance configured ready to parse
     */
    @SuppressWarnings("rawtypes")
    public static TemplateInstanceBeanBuilder buildInstance(TemplateDefinitionBean definition) {
        return buildBuilder(definition);
    }

    @SuppressWarnings({"rawtypes"})
    private static TemplateInstanceBeanBuilder buildBuilder(TemplateDefinitionBean definition) {
        return builder().name(definition.getName()).charSet(definition.getCharSet()).contentType(definition.getContentType()).template(definition.getTemplate()).locale(new Locale("")).messages(new ResourceBundleMessageSource());
    }

    /**
     * Build an instance with {@code locale} and without {@link TemplateInstanceBean#getMessages()} and an empty {@link TemplateInstanceBean#getVariables()}. 
     * @param definition The template definition
     * @param locale The locale
     * @return The instance configured ready to parse
     */
    @SuppressWarnings("rawtypes")
    public static TemplateInstanceBeanBuilder buildInstance(TemplateDefinitionBean definition, Locale locale) {
        return buildBuilder(definition).locale(locale);
    }

    /**
     * Build an instance with default {@code locale} and a {@link TemplateInstanceBean#getMessages() resource messages} from {@code baseNames} and an empty {@link TemplateInstanceBean#getVariables()}. 
     * @param definition The template definition
     * @param baseNames The base names or messages for search for
     * @return The instance configured ready to parse
     */
    @SuppressWarnings("rawtypes")
    public static TemplateInstanceBeanBuilder buildInstance(TemplateDefinitionBean definition, String baseNames) {
        ResourceBundleMessageSource rb;
        rb = new ResourceBundleMessageSource();
        rb.addBasenames(baseNames);
        return buildBuilder(definition).messages(rb);
    }

    /**
     * Build an instance with {@code locale} and a {@link TemplateInstanceBean#getMessages() resource messages} from {@code baseNames} and an empty {@link TemplateInstanceBean#getVariables()}. 
     * @param definition The template definition
     * @param locale The locale
     * @param baseNames The base names or messages for search for
     * @return The instance configured ready to parse
     */
    @SuppressWarnings("rawtypes")
    public static TemplateInstanceBeanBuilder buildInstance(TemplateDefinitionBean definition, Locale locale, String baseNames) {
        ResourceBundleMessageSource rb;
        rb = new ResourceBundleMessageSource();
        rb.addBasenames(baseNames);
        return buildBuilder(definition).locale(locale).messages(rb);
    }

    @java.lang.SuppressWarnings("all")
    private static Map<String, Object> $default$variables() {
        return new TreeMap<>();
    }


    @java.lang.SuppressWarnings("all")
    public static abstract class TemplateInstanceBeanBuilder<C extends TemplateInstanceBean, B extends TemplateInstanceBean.TemplateInstanceBeanBuilder<C, B>> extends TemplateDefinitionBean.TemplateDefinitionBeanBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        private MessageSource messages;
        @java.lang.SuppressWarnings("all")
        private boolean variables$set;
        @java.lang.SuppressWarnings("all")
        private Map<String, Object> variables$value;
        @java.lang.SuppressWarnings("all")
        private Locale locale;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TemplateInstanceBean.TemplateInstanceBeanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(final TemplateInstanceBean instance, final TemplateInstanceBean.TemplateInstanceBeanBuilder<?, ?> b) {
            b.messages(instance.messages);
            b.variables(instance.variables);
            b.locale(instance.locale);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.SuppressWarnings("all")
        public B messages(final MessageSource messages) {
            this.messages = messages;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B variables(final Map<String, Object> variables) {
            this.variables$value = variables;
            variables$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B locale(final Locale locale) {
            this.locale = locale;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "TemplateInstanceBean.TemplateInstanceBeanBuilder(super=" + super.toString() + ", messages=" + this.messages + ", variables$value=" + this.variables$value + ", locale=" + this.locale + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    private static final class TemplateInstanceBeanBuilderImpl extends TemplateInstanceBean.TemplateInstanceBeanBuilder<TemplateInstanceBean, TemplateInstanceBean.TemplateInstanceBeanBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private TemplateInstanceBeanBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected TemplateInstanceBean.TemplateInstanceBeanBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public TemplateInstanceBean build() {
            return new TemplateInstanceBean(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected TemplateInstanceBean(final TemplateInstanceBean.TemplateInstanceBeanBuilder<?, ?> b) {
        super(b);
        this.messages = b.messages;
        if (b.variables$set) this.variables = b.variables$value;
         else this.variables = TemplateInstanceBean.$default$variables();
        this.locale = b.locale;
    }

    @java.lang.SuppressWarnings("all")
    public static TemplateInstanceBean.TemplateInstanceBeanBuilder<?, ?> builder() {
        return new TemplateInstanceBean.TemplateInstanceBeanBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public TemplateInstanceBean.TemplateInstanceBeanBuilder<?, ?> toBuilder() {
        return new TemplateInstanceBean.TemplateInstanceBeanBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.SuppressWarnings("all")
    public MessageSource getMessages() {
        return this.messages;
    }

    @java.lang.SuppressWarnings("all")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @java.lang.SuppressWarnings("all")
    public Locale getLocale() {
        return this.locale;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "TemplateInstanceBean(super=" + super.toString() + ", messages=" + this.getMessages() + ", variables=" + this.getVariables() + ", locale=" + this.getLocale() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TemplateInstanceBean)) return false;
        final TemplateInstanceBean other = (TemplateInstanceBean) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$messages = this.getMessages();
        final java.lang.Object other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !this$messages.equals(other$messages)) return false;
        final java.lang.Object this$variables = this.getVariables();
        final java.lang.Object other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !this$variables.equals(other$variables)) return false;
        final java.lang.Object this$locale = this.getLocale();
        final java.lang.Object other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TemplateInstanceBean;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $messages = this.getMessages();
        result = result * PRIME + ($messages == null ? 43 : $messages.hashCode());
        final java.lang.Object $variables = this.getVariables();
        result = result * PRIME + ($variables == null ? 43 : $variables.hashCode());
        final java.lang.Object $locale = this.getLocale();
        result = result * PRIME + ($locale == null ? 43 : $locale.hashCode());
        return result;
    }

    @java.lang.SuppressWarnings("all")
    public TemplateInstanceBean() {
    }

    @java.lang.SuppressWarnings("all")
    public TemplateInstanceBean(final MessageSource messages, final Map<String, Object> variables, final Locale locale) {
        this.messages = messages;
        this.variables = variables;
        this.locale = locale;
    }

    @java.lang.SuppressWarnings("all")
    public void setMessages(@NotNull final MessageSource messages) {
        this.messages = messages;
    }

    @java.lang.SuppressWarnings("all")
    public void setVariables(@NotNull final Map<String, Object> variables) {
        this.variables = variables;
    }

    @java.lang.SuppressWarnings("all")
    public void setLocale(@NotNull final Locale locale) {
        this.locale = locale;
    }
}
