// Generated by delombok at Sun Jun 13 03:09:07 CEST 2021
/*
 * This file is part of "albirar albirar-template-engine".
 * 
 * "albirar albirar-template-engine" is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * "albirar albirar-template-engine" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "albirar albirar-template-engine" source code.  If not, see <https://www.gnu.org/licenses/gpl-3.0.html>.
 *
 * Copyright (C) 2020 Octavi Fornés
 */
package cat.albirar.template.engine.models;

import java.io.Serializable;
import java.nio.charset.Charset;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.context.ApplicationContext;
import cat.albirar.template.engine.EContentType;
import lombok.Builder.Default;

/**
 * The template definition bean.
 * @author Octavi Forn&eacute;s &lt;<a href="mailto:ofornes@albirar.cat">ofornes@albirar.cat</a>&gt;
 * @since 1.0.0, 2.2.0
 */
public class TemplateDefinitionBean implements Serializable {
    private static final long serialVersionUID = 7550617345858079032L;
    public static final String DEFAULT_CHARSET = "utf-8";
    public static final EContentType DEFAULT_CONTENT_TYPE = EContentType.TEXT_PLAIN;
    /**
     * A symbolic name for this template.
     */
    @NotBlank
    private String name;
    /**
     * The template resource path, can be any of the resources resolved by {@link ApplicationContext#getResource(String)}.
     *
     * @see ApplicationContext#getResource(String)
     */
    @NotBlank
    private String template;
    /**
     * The template engine language.
     * Identify the engine capable of transform the given template
     */
    @NotBlank
    private String templateEngineLanguage;
    /**
     * The resulting content type of this template.
     */
    @NotNull
    private EContentType contentType;
    /**
     * The charset of resulting content from this template.
     */
    @NotNull
    private Charset charSet;

    @java.lang.SuppressWarnings("all")
    private static EContentType $default$contentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    @java.lang.SuppressWarnings("all")
    private static Charset $default$charSet() {
        return Charset.forName(DEFAULT_CHARSET);
    }


    @java.lang.SuppressWarnings("all")
    public static abstract class TemplateDefinitionBeanBuilder<C extends TemplateDefinitionBean, B extends TemplateDefinitionBean.TemplateDefinitionBeanBuilder<C, B>> {
        @java.lang.SuppressWarnings("all")
        private String name;
        @java.lang.SuppressWarnings("all")
        private String template;
        @java.lang.SuppressWarnings("all")
        private String templateEngineLanguage;
        @java.lang.SuppressWarnings("all")
        private boolean contentType$set;
        @java.lang.SuppressWarnings("all")
        private EContentType contentType$value;
        @java.lang.SuppressWarnings("all")
        private boolean charSet$set;
        @java.lang.SuppressWarnings("all")
        private Charset charSet$value;

        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            TemplateDefinitionBean.TemplateDefinitionBeanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(final TemplateDefinitionBean instance, final TemplateDefinitionBean.TemplateDefinitionBeanBuilder<?, ?> b) {
            b.name(instance.name);
            b.template(instance.template);
            b.templateEngineLanguage(instance.templateEngineLanguage);
            b.contentType(instance.contentType);
            b.charSet(instance.charSet);
        }

        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.SuppressWarnings("all")
        public B name(final String name) {
            this.name = name;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B template(final String template) {
            this.template = template;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B templateEngineLanguage(final String templateEngineLanguage) {
            this.templateEngineLanguage = templateEngineLanguage;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B contentType(final EContentType contentType) {
            this.contentType$value = contentType;
            contentType$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B charSet(final Charset charSet) {
            this.charSet$value = charSet;
            charSet$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "TemplateDefinitionBean.TemplateDefinitionBeanBuilder(name=" + this.name + ", template=" + this.template + ", templateEngineLanguage=" + this.templateEngineLanguage + ", contentType$value=" + this.contentType$value + ", charSet$value=" + this.charSet$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    private static final class TemplateDefinitionBeanBuilderImpl extends TemplateDefinitionBean.TemplateDefinitionBeanBuilder<TemplateDefinitionBean, TemplateDefinitionBean.TemplateDefinitionBeanBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private TemplateDefinitionBeanBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected TemplateDefinitionBean.TemplateDefinitionBeanBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public TemplateDefinitionBean build() {
            return new TemplateDefinitionBean(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected TemplateDefinitionBean(final TemplateDefinitionBean.TemplateDefinitionBeanBuilder<?, ?> b) {
        this.name = b.name;
        this.template = b.template;
        this.templateEngineLanguage = b.templateEngineLanguage;
        if (b.contentType$set) this.contentType = b.contentType$value;
         else this.contentType = TemplateDefinitionBean.$default$contentType();
        if (b.charSet$set) this.charSet = b.charSet$value;
         else this.charSet = TemplateDefinitionBean.$default$charSet();
    }

    @java.lang.SuppressWarnings("all")
    public static TemplateDefinitionBean.TemplateDefinitionBeanBuilder<?, ?> builder() {
        return new TemplateDefinitionBean.TemplateDefinitionBeanBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public TemplateDefinitionBean.TemplateDefinitionBeanBuilder<?, ?> toBuilder() {
        return new TemplateDefinitionBean.TemplateDefinitionBeanBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * A symbolic name for this template.
     */
    @java.lang.SuppressWarnings("all")
    public String getName() {
        return this.name;
    }

    /**
     * The template resource path, can be any of the resources resolved by {@link ApplicationContext#getResource(String)}.
     * @return The template resource path
     *
     * @see ApplicationContext#getResource(String)
     */
    @java.lang.SuppressWarnings("all")
    public String getTemplate() {
        return this.template;
    }

    /**
     * The template engine language.
     * Identify the engine capable of transform the given template
     */
    @java.lang.SuppressWarnings("all")
    public String getTemplateEngineLanguage() {
        return this.templateEngineLanguage;
    }

    /**
     * The resulting content type of this template.
     */
    @java.lang.SuppressWarnings("all")
    public EContentType getContentType() {
        return this.contentType;
    }

    /**
     * The charset of resulting content from this template.
     */
    @java.lang.SuppressWarnings("all")
    public Charset getCharSet() {
        return this.charSet;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TemplateDefinitionBean)) return false;
        final TemplateDefinitionBean other = (TemplateDefinitionBean) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$template = this.getTemplate();
        final java.lang.Object other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) return false;
        final java.lang.Object this$templateEngineLanguage = this.getTemplateEngineLanguage();
        final java.lang.Object other$templateEngineLanguage = other.getTemplateEngineLanguage();
        if (this$templateEngineLanguage == null ? other$templateEngineLanguage != null : !this$templateEngineLanguage.equals(other$templateEngineLanguage)) return false;
        final java.lang.Object this$contentType = this.getContentType();
        final java.lang.Object other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) return false;
        final java.lang.Object this$charSet = this.getCharSet();
        final java.lang.Object other$charSet = other.getCharSet();
        if (this$charSet == null ? other$charSet != null : !this$charSet.equals(other$charSet)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TemplateDefinitionBean;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $template = this.getTemplate();
        result = result * PRIME + ($template == null ? 43 : $template.hashCode());
        final java.lang.Object $templateEngineLanguage = this.getTemplateEngineLanguage();
        result = result * PRIME + ($templateEngineLanguage == null ? 43 : $templateEngineLanguage.hashCode());
        final java.lang.Object $contentType = this.getContentType();
        result = result * PRIME + ($contentType == null ? 43 : $contentType.hashCode());
        final java.lang.Object $charSet = this.getCharSet();
        result = result * PRIME + ($charSet == null ? 43 : $charSet.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "TemplateDefinitionBean(name=" + this.getName() + ", template=" + this.getTemplate() + ", templateEngineLanguage=" + this.getTemplateEngineLanguage() + ", contentType=" + this.getContentType() + ", charSet=" + this.getCharSet() + ")";
    }

    @java.lang.SuppressWarnings("all")
    public TemplateDefinitionBean() {
    }

    @java.lang.SuppressWarnings("all")
    public TemplateDefinitionBean(final String name, final String template, final String templateEngineLanguage, final EContentType contentType, final Charset charSet) {
        this.name = name;
        this.template = template;
        this.templateEngineLanguage = templateEngineLanguage;
        this.contentType = contentType;
        this.charSet = charSet;
    }

    /**
     * A symbolic name for this template.
     */
    @java.lang.SuppressWarnings("all")
    public void setName(@NotBlank final String name) {
        this.name = name;
    }

    /**
     * The template resource path, can be any of the resources resolved by {@link ApplicationContext#getResource(String)}.
     *
     * @param template The template resource path
     * @see ApplicationContext#getResource(String)
     */
    @java.lang.SuppressWarnings("all")
    public void setTemplate(@NotBlank final String template) {
        this.template = template;
    }

    /**
     * The template engine language.
     * Identify the engine capable of transform the given template
     */
    @java.lang.SuppressWarnings("all")
    public void setTemplateEngineLanguage(@NotBlank final String templateEngineLanguage) {
        this.templateEngineLanguage = templateEngineLanguage;
    }

    /**
     * The resulting content type of this template.
     */
    @java.lang.SuppressWarnings("all")
    public void setContentType(@NotNull final EContentType contentType) {
        this.contentType = contentType;
    }

    /**
     * The charset of resulting content from this template.
     */
    @java.lang.SuppressWarnings("all")
    public void setCharSet(@NotNull final Charset charSet) {
        this.charSet = charSet;
    }
}
