/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.registry;

import cat.albirar.template.engine.ITemplateEngineFactory;
import cat.albirar.template.engine.models.TemplateInstanceBean;
import cat.albirar.template.engine.service.ITemplateEngine;
import cat.albirar.template.engine.service.ITemplateEngineRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class TemplateEngineRegistryDefaultImpl
implements ITemplateEngineRegistry,
ITemplateEngineFactory {
    private Map<String, ITemplateEngine> engines = new HashMap<String, ITemplateEngine>();

    @Override
    public Optional<ITemplateEngine> getTemplateEngine(@NotBlank String templateLanguage) {
        return Optional.ofNullable(this.engines.get(templateLanguage));
    }

    @Override
    public List<String> getRegisteredTemplateLanguages() {
        return Collections.unmodifiableList(this.engines.keySet().stream().collect(Collectors.toList()));
    }

    @Override
    public void register(@NotNull @Valid ITemplateEngine templateEngine) {
        this.engines.put(templateEngine.getTemplateLanguage(), templateEngine);
    }

    @Override
    public String renderTemplate(@NotNull @Valid TemplateInstanceBean template) {
        Optional<ITemplateEngine> te = this.getTemplateEngine(template.getTemplateEngineLanguage());
        if (te.isPresent()) {
            return te.get().renderTemplate(template);
        }
        throw new IllegalStateException("No engine was registerd for the template language '".concat(template.getTemplateEngineLanguage()).concat("'"));
    }
}

