/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.service;

import cat.albirar.template.engine.models.TemplateInstanceBean;
import java.util.Locale;
import java.util.Set;
import javax.validation.ValidationException;
import org.springframework.util.StringUtils;
import org.thymeleaf.context.IContext;

public class TemplateEngineContext
implements IContext {
    private TemplateInstanceBean templateInstance;

    public TemplateEngineContext(TemplateInstanceBean t) {
        if (t == null) {
            throw new ValidationException();
        }
        this.templateInstance = t;
    }

    public Locale getLocale() {
        return this.templateInstance.getLocale();
    }

    public boolean containsVariable(String name) {
        if (!StringUtils.hasText((String)name)) {
            throw new ValidationException();
        }
        return this.templateInstance.getVariables().containsKey(name);
    }

    public Set<String> getVariableNames() {
        return this.templateInstance.getVariables().keySet();
    }

    public Object getVariable(String name) {
        if (!StringUtils.hasText((String)name)) {
            throw new ValidationException();
        }
        return this.templateInstance.getVariables().get(name);
    }

    public TemplateInstanceBean getTemplateInstance() {
        return this.templateInstance;
    }
}

