/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.test.app.configuration;

import cat.albirar.template.engine.configuration.PropertiesTemplate;
import cat.albirar.template.engine.models.ConfigurationPropertiesBean;
import cat.albirar.template.engine.test.app.configuration.AutoConfigurationTestConfiguration;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;

@SpringBootTest(args={"--debug"})
public class AutoConfigurationTest {
    @Autowired
    SpringTemplateEngine templateEngine;
    @Autowired
    SpringResourceTemplateResolver templateResolver;
    @Autowired
    ConfigurationPropertiesBean configurationPropertiesBean;

    @Test
    public void when_overridingConfigurationIsMade_then_AssertThatIsApplied() {
        Assertions.assertSame((Object)this.templateEngine, (Object)AutoConfigurationTestConfiguration.templateEngine);
        Assertions.assertSame((Object)this.templateResolver, (Object)AutoConfigurationTestConfiguration.templateResolver);
    }

    @Test
    public void when_configurationIsLoad_then_PropertiesAreDefault() {
        Assertions.assertEquals((Object)PropertiesTemplate.DEFAULT_CHARSET, (Object)this.configurationPropertiesBean.getCharset());
        List dirs = Stream.of(PropertiesTemplate.DEFAULT_DIR_ARRAY).map(d -> Paths.get(d, new String[0])).collect(Collectors.toList());
        Assertions.assertEquals(dirs, (Object)this.configurationPropertiesBean.getDirectories());
    }
}

