/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.test.service;

import cat.albirar.template.engine.ITemplateEngineFactory;
import cat.albirar.template.engine.models.TemplateDefinitionBean;
import cat.albirar.template.engine.models.TemplateInstanceBean;
import cat.albirar.template.engine.test.configuration.DefaultTestConfiguration;
import cat.albirar.template.engine.test.service.AbstractTest;
import cat.albirar.template.engine.test.service.TestUser;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.validation.ValidationException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.StringUtils;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={DefaultTestConfiguration.class})
public class TemplateEngineFactoryTest
extends AbstractTest {
    private static final TestUser[] VARS_USERS = new TestUser[]{TestUser.builder().name("Username 1").var1(11L).var2(LocalDateTime.now().minusDays(1L).withNano(0)).var3("User 1 - var 3").build(), TestUser.builder().name("Username 2").var1(22L).var2(LocalDateTime.now().minusDays(2L).withNano(0)).var3("User 2 - var 3").build(), TestUser.builder().name("Username 3").var1(33L).var2(LocalDateTime.now().minusDays(3L).withNano(0)).var3("User 3 - var 3").build(), TestUser.builder().name("Username 4").var1(44L).var2(LocalDateTime.now().minusDays(4L).withNano(0)).var3("User 4 - var 3").build()};
    @Autowired
    private ITemplateEngineFactory templateEnginefactory;

    @Test
    public void when_argumentsToRenderAreNullOrInvalid_then_aValidationExceptionIsThrown() {
        Assertions.assertThrows(ValidationException.class, () -> {
            String string = this.templateEnginefactory.renderTemplate(null);
        });
        Assertions.assertThrows(ValidationException.class, () -> {
            String string = this.templateEnginefactory.renderTemplate(TemplateInstanceBean.builder().build());
        });
    }

    @Test
    public void when_anUnknownTemplateLanguageInstanceIsRender_then_anIllegalStateExceptionIsThrown() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            String string = this.templateEnginefactory.renderTemplate(TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleHtmlTemplateDefinition.toBuilder().templateEngineLanguage("xxx").build()).build());
        });
    }

    @Test
    public void when_anHtmlTemplateInstanceWithoutMessagesNorVariablesIsRender_then_aCorrectResultIsReturn() {
        String tx = this.templateEnginefactory.renderTemplate(TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleHtmlTemplateDefinition.toBuilder().build()).build());
        Assertions.assertNotNull((Object)tx);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)tx));
        Document parsed = Jsoup.parse((String)tx);
        Assertions.assertEquals((int)1, (int)parsed.select("h1").size());
        Assertions.assertEquals((Object)"Text", (Object)parsed.select("h1").first().text());
        Assertions.assertEquals((int)1, (int)parsed.select("p").size());
        Assertions.assertEquals((Object)"A simple template", (Object)parsed.select("p").first().text());
    }

    @Test
    public void when_anHtmlTemplateInstanceWithVariablesNotMessagesIsRender_then_aCorrectResultIsReturn() {
        TreeMap<String, Object> vars = new TreeMap<String, Object>();
        vars.put("title", "Vars test title");
        vars.put("users", Arrays.asList(VARS_USERS));
        TemplateInstanceBean tinst = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)varHtmlTemplateDefinition.toBuilder().build()).variables(vars).build();
        String r = this.templateEnginefactory.renderTemplate(tinst);
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        Document parsed = Jsoup.parse((String)r);
        Assertions.assertEquals((int)1, (int)parsed.select("h1").size());
        Assertions.assertEquals((Object)"Vars test title", (Object)parsed.select("h1").first().text());
        Elements vu = parsed.select("li.user");
        Assertions.assertEquals((int)VARS_USERS.length, (int)vu.size());
        int n = 0;
        for (Element element : vu) {
            this.assertUser(VARS_USERS[n], element, null);
            ++n;
        }
    }

    @Test
    public void when_anHtmlTemplateInstanceWithVariablesAndMessagesIsRender_then_aCorrectResultIsReturn() {
        TreeMap<String, Object> vars = new TreeMap<String, Object>();
        vars.put("title", "Vars &amp; Msg test title");
        vars.put("users", Arrays.asList(VARS_USERS));
        TemplateInstanceBean tinst = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)varMsgHtmlTemplateDefinition, (String)"cat/albirar/template/engine/test/messages/testMessages").variables(vars).build();
        String r = this.templateEnginefactory.renderTemplate(tinst);
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        Document parsed = Jsoup.parse((String)r);
        Assertions.assertEquals((int)1, (int)parsed.select("h1").size());
        Assertions.assertEquals((Object)"Vars &amp; Msg test title", (Object)parsed.select("h1").first().text());
        Assertions.assertEquals((int)1, (int)parsed.select("p").size());
        Assertions.assertEquals((Object)"This is a template for test with variables", (Object)parsed.select("p").text());
        Elements vu = parsed.select("li.user");
        Assertions.assertEquals((int)VARS_USERS.length, (int)vu.size());
        int n = 0;
        for (Element element : vu) {
            this.assertUser(VARS_USERS[n], element, "User name:&nbsp;");
            ++n;
        }
        r = this.templateEnginefactory.renderTemplate(tinst.toBuilder().locale(new Locale("ca")).build());
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        parsed = Jsoup.parse((String)r);
        Assertions.assertEquals((int)1, (int)parsed.select("h1").size());
        Assertions.assertEquals((Object)"Vars &amp; Msg test title", (Object)parsed.select("h1").first().text());
        Assertions.assertEquals((int)1, (int)parsed.select("p").size());
        Assertions.assertEquals((Object)"Aquesta \u00e9s una plantilla de prova amb variables", (Object)parsed.select("p").text());
        vu = parsed.select("li.user");
        Assertions.assertEquals((int)VARS_USERS.length, (int)vu.size());
        n = 0;
        for (Element element : vu) {
            this.assertUser(VARS_USERS[n], element, "Nom d'usuari:&nbsp;");
            ++n;
        }
        r = this.templateEnginefactory.renderTemplate(tinst.toBuilder().locale(new Locale("fr")).build());
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        parsed = Jsoup.parse((String)r);
        Assertions.assertEquals((int)1, (int)parsed.select("h1").size());
        Assertions.assertEquals((Object)"Vars &amp; Msg test title", (Object)parsed.select("h1").first().text());
        Assertions.assertEquals((int)1, (int)parsed.select("p").size());
        Assertions.assertEquals((Object)"Ceci est un mod\u00e8le de test avec des variables", (Object)parsed.select("p").text());
        vu = parsed.select("li.user");
        Assertions.assertEquals((int)VARS_USERS.length, (int)vu.size());
        n = 0;
        for (Element element : vu) {
            this.assertUser(VARS_USERS[n], element, "Nom d'utilisateur:&nbsp;");
            ++n;
        }
    }

    @Test
    public void when_aTxtTemplateInstanceWithoutMessagesNorVariablesIsRender_then_aCorrectResultIsReturn() {
        String tx = this.templateEnginefactory.renderTemplate(TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleTxtTemplateDefinition.toBuilder().build()).build());
        Assertions.assertNotNull((Object)tx);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)tx));
        Assertions.assertEquals((Object)"Hello,\n\nThis is a simple text template without variables nor messages\n\nBye!", (Object)tx);
    }

    @Test
    public void when_aTxtTemplateInstanceWithVariablesNotMessagesIsRender_then_aCorrectResultIsReturn() {
        TreeMap<String, Object> vars = new TreeMap<String, Object>();
        vars.put("title", "Vars test title");
        vars.put("users", Arrays.asList(VARS_USERS));
        TemplateInstanceBean tinst = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)varTxtTemplateDefinition.toBuilder().build()).variables(vars).build();
        String r = this.templateEnginefactory.renderTemplate(tinst);
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        StringBuilder stb = new StringBuilder("Vars test title").append("\nThis is a template text for test with variables\n\nUsers:\n");
        TestUser[] testUserArray = VARS_USERS;
        int n = VARS_USERS.length;
        int n2 = 0;
        while (n2 < n) {
            TestUser usr = testUserArray[n2];
            stb.append(usr.getName()).append("\n   ").append(usr.getVar1()).append("\n   ").append(usr.getVar2()).append("\n   ").append(usr.getVar3()).append("\n\n");
            ++n2;
        }
        Assertions.assertEquals((Object)stb.toString(), (Object)r);
    }

    @Test
    public void when_aTxtTemplateInstanceWithVariablesAndMessagesIsRender_then_aCorrectResultIsReturn() {
        TestUser usr;
        TreeMap<String, Object> vars = new TreeMap<String, Object>();
        vars.put("title", "Vars & Msg test title");
        vars.put("users", Arrays.asList(VARS_USERS));
        TemplateInstanceBean tinst = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)varMsgTxtTemplateDefinition, (String)"cat/albirar/template/engine/test/messages/testMessages").variables(vars).build();
        String r = this.templateEnginefactory.renderTemplate(tinst);
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        StringBuilder stb = new StringBuilder("Vars &amp; Msg test title").append("\n\n").append("This is a template for test with variables").append("\n\n");
        TestUser[] testUserArray = VARS_USERS;
        int n = VARS_USERS.length;
        int n2 = 0;
        while (n2 < n) {
            usr = testUserArray[n2];
            stb.append("User name: ").append(usr.getName()).append("\n   ").append(usr.getVar1()).append("\n   ").append(usr.getVar2()).append("\n   ").append(usr.getVar3()).append("\n\n");
            ++n2;
        }
        Assertions.assertEquals((Object)stb.toString(), (Object)r);
        r = this.templateEnginefactory.renderTemplate(tinst.toBuilder().locale(new Locale("ca")).build());
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        stb = new StringBuilder("Vars &amp; Msg test title").append("\n\n").append("Aquesta \u00e9s una plantilla de prova amb variables").append("\n\n");
        testUserArray = VARS_USERS;
        n = VARS_USERS.length;
        n2 = 0;
        while (n2 < n) {
            usr = testUserArray[n2];
            stb.append("Nom d'usuari: ").append(usr.getName()).append("\n   ").append(usr.getVar1()).append("\n   ").append(usr.getVar2()).append("\n   ").append(usr.getVar3()).append("\n\n");
            ++n2;
        }
        Assertions.assertEquals((Object)stb.toString(), (Object)r);
        r = this.templateEnginefactory.renderTemplate(tinst.toBuilder().locale(new Locale("fr")).build());
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)StringUtils.hasText((String)r));
        stb = new StringBuilder("Vars &amp; Msg test title").append("\n\n").append("Ceci est un mod\u00e8le de test avec des variables").append("\n\n");
        testUserArray = VARS_USERS;
        n = VARS_USERS.length;
        n2 = 0;
        while (n2 < n) {
            usr = testUserArray[n2];
            stb.append("Nom d'utilisateur: ").append(usr.getName()).append("\n   ").append(usr.getVar1()).append("\n   ").append(usr.getVar2()).append("\n   ").append(usr.getVar3()).append("\n\n");
            ++n2;
        }
        Assertions.assertEquals((Object)stb.toString(), (Object)r);
    }

    @Test
    public void when_theTemplateLanguageListIsRequested_then_aNotEmptyListIsGetWithTheCorrectElements() {
        ArrayList<String> l1 = new ArrayList<String>();
        String[] stringArray = REGISTERED_TEMPLATES;
        int n = REGISTERED_TEMPLATES.length;
        int n2 = 0;
        while (n2 < n) {
            String tl = stringArray[n2];
            l1.add(tl);
            ++n2;
        }
        List lr = this.templateEnginefactory.getRegisteredTemplateLanguages();
        Assertions.assertNotNull((Object)lr);
        Assertions.assertFalse((boolean)lr.isEmpty());
        Assertions.assertEquals(l1, (Object)lr);
    }

    private void assertUser(TestUser user, Element element, String label) {
        if (StringUtils.hasText((String)label)) {
            Assertions.assertEquals((Object)label, (Object)element.select("span").text());
        }
        Assertions.assertEquals((Object)user.getName(), (Object)element.select("strong").text());
        Elements vuVars = element.select("ol > li");
        Assertions.assertEquals((int)3, (int)vuVars.size());
        Assertions.assertEquals((Object)Long.valueOf(user.getVar1()).toString(), (Object)((Element)vuVars.get(0)).text());
        Assertions.assertEquals((Object)user.getVar2().toString(), (Object)((Element)vuVars.get(1)).text());
        Assertions.assertEquals((Object)user.getVar3(), (Object)((Element)vuVars.get(2)).text());
    }
}

