/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.configuration;

import cat.albirar.template.engine.models.ConfigurationPropertiesBean;
import cat.albirar.template.engine.registry.TemplateEngineRegistryDefaultImpl;
import cat.albirar.template.engine.service.ITemplateEngine;
import cat.albirar.template.engine.service.impl.ThymeleafSpringTemplateEngineImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties
@PropertySource(value={"classpath:/albirar-template-engine.yaml"})
@ComponentScan(basePackageClasses={ITemplateEngine.class, ThymeleafSpringTemplateEngineImpl.class, TemplateEngineRegistryDefaultImpl.class})
public class TemplateEngineConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SpringTemplateEngine templateEngine(@Autowired SpringResourceTemplateResolver resolver) {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)resolver);
        return templateEngine;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringResourceTemplateResolver thymeleafTemplateResolver(@Autowired ConfigurationPropertiesBean configurationProperties) {
        SpringResourceTemplateResolver templateResolver = new SpringResourceTemplateResolver();
        templateResolver.setCharacterEncoding(configurationProperties.getCharset().name());
        return templateResolver;
    }

    @Bean
    @ConfigurationProperties(prefix="albirar.templates")
    public ConfigurationPropertiesBean configurationPropertiesBean() {
        return ConfigurationPropertiesBean.builder().build();
    }
}

