/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.registry;

import cat.albirar.template.engine.ITemplateEngineFactory;
import cat.albirar.template.engine.models.TemplateInstanceBean;
import cat.albirar.template.engine.service.ITemplateEngine;
import cat.albirar.template.engine.service.ITemplateEngineRegistry;
import cat.albirar.template.engine.service.TemplateNotAccessibleException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class TemplateEngineRegistryDefaultImpl
implements ITemplateEngineRegistry,
ITemplateEngineFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateEngineRegistryDefaultImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    private Map<String, ITemplateEngine> engines = new HashMap<String, ITemplateEngine>();

    @Override
    public Optional<ITemplateEngine> getTemplateEngine(@NotBlank String templateLanguage) {
        LOGGER.debug("Search template engine for {} template language", (Object)templateLanguage);
        return Optional.ofNullable(this.engines.get(templateLanguage));
    }

    @Override
    public List<String> getRegisteredTemplateLanguages() {
        LOGGER.debug("Compound registered template languages list {}", this.engines.keySet());
        return Collections.unmodifiableList(this.engines.keySet().stream().collect(Collectors.toList()));
    }

    @Override
    public void register(@NotNull @Valid ITemplateEngine templateEngine) {
        LOGGER.debug("Register a new template engine for {} template language", (Object)templateEngine.getTemplateLanguage());
        this.engines.put(templateEngine.getTemplateLanguage(), templateEngine);
    }

    @Override
    public String renderTemplate(@NotNull @Valid TemplateInstanceBean template) {
        LOGGER.debug("Render template {} of {} template language", (Object)template.getName(), (Object)template.getTemplateEngineLanguage());
        Optional<ITemplateEngine> te = this.getTemplateEngine(template.getTemplateEngineLanguage());
        if (te.isPresent()) {
            LOGGER.debug("Template engine for {} template language found, check resources...", (Object)template.getTemplateEngineLanguage());
            this.checkResource(template.getTemplate());
            LOGGER.debug("Template engine for {} template language found and resources checked, render it", (Object)template.getTemplateEngineLanguage());
            return te.get().renderTemplate(template);
        }
        LOGGER.debug("Template engine for {} template language NOT FOUND!", (Object)template.getTemplateEngineLanguage());
        throw new IllegalStateException("No engine was registerd for the template language '".concat(template.getTemplateEngineLanguage()).concat("'"));
    }

    private void checkResource(String strResource) {
        LOGGER.debug("Check resource {}", (Object)strResource);
        Resource resource = this.applicationContext.getResource(strResource);
        if (!resource.exists()) {
            LOGGER.error("Resource {} DOES NOT EXISTS!", (Object)strResource);
            throw new TemplateNotAccessibleException(String.format("The resource '%s' does not exists!", strResource));
        }
        try {
            if (!resource.getFile().isFile()) {
                LOGGER.error("Resource {} IS NOT A FILE!", (Object)strResource);
                throw new TemplateNotAccessibleException(String.format("The resource '%s' is not a regular file!", strResource));
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("IOException on get the file for resource %s!", strResource), (Throwable)e);
        }
        if (!resource.isReadable()) {
            LOGGER.error("Resource {} IS NOT READABLE!", (Object)strResource);
            throw new TemplateNotAccessibleException(String.format("The resource '%s' is not readable!", strResource));
        }
        LOGGER.debug("Resource {} IS OK!", (Object)strResource);
    }
}

