/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.service.impl;

import cat.albirar.template.engine.models.TemplateInstanceBean;
import cat.albirar.template.engine.service.ITemplateEngine;
import cat.albirar.template.engine.service.ITemplateEngineRegistry;
import cat.albirar.template.engine.service.TemplateEngineContext;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Component
public class ThymeleafSpringTemplateEngineImpl
implements ITemplateEngine,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThymeleafSpringTemplateEngineImpl.class);
    public static final String TEMPLATE_LANGUAGE = "thymeleaf-spring";
    @Autowired
    private SpringResourceTemplateResolver templateResolver;
    @Autowired
    private ITemplateEngineRegistry registry;

    public void afterPropertiesSet() throws Exception {
        this.registry.register(this);
    }

    @Override
    public String getTemplateLanguage() {
        return TEMPLATE_LANGUAGE;
    }

    @Override
    public String renderTemplate(TemplateInstanceBean template) {
        LOGGER.debug("Render template {}", (Object)template);
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver);
        templateEngine.setMessageSource(template.getMessages());
        TemplateSpec tspec = new TemplateSpec(template.getTemplate(), Collections.emptySet(), template.getContentType().getTemplateMode(), template.getVariables());
        return templateEngine.process(tspec, (IContext)new TemplateEngineContext(template));
    }
}

