/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.test.service;

import cat.albirar.template.engine.models.TemplateDefinitionBean;
import cat.albirar.template.engine.models.TemplateInstanceBean;
import cat.albirar.template.engine.service.TemplateEngineContext;
import cat.albirar.template.engine.test.configuration.DefaultTestConfiguration;
import cat.albirar.template.engine.test.service.AbstractTest;
import javax.validation.ValidationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={DefaultTestConfiguration.class})
public class TemplateEngineContextTest
extends AbstractTest {
    @Test
    public void when_argumentsToMethodsAreNotValids_then_ValidationExceptionIsThrown() {
        Assertions.assertThrows(ValidationException.class, () -> new TemplateEngineContext(null));
        TemplateEngineContext tec = new TemplateEngineContext(TemplateInstanceBean.buildInstance((TemplateDefinitionBean)varMsgHtmlTemplateDefinition).build());
        Assertions.assertThrows(ValidationException.class, () -> tec.containsVariable(null));
        Assertions.assertThrows(ValidationException.class, () -> tec.containsVariable(""));
        Assertions.assertThrows(ValidationException.class, () -> tec.containsVariable("   "));
        Assertions.assertThrows(ValidationException.class, () -> tec.getVariable(null));
        Assertions.assertThrows(ValidationException.class, () -> tec.getVariable(""));
        Assertions.assertThrows(ValidationException.class, () -> tec.getVariable("   "));
    }

    @Test
    public void when_valuesAreSetted_then_allGettersAreOk() {
        TemplateInstanceBean tib = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleHtmlTemplateDefinition).build();
        TemplateEngineContext tec = new TemplateEngineContext(tib);
        Assertions.assertNotNull((Object)tec.getLocale());
        Assertions.assertEquals((Object)tib.getLocale(), (Object)tec.getLocale());
        Assertions.assertTrue((boolean)tec.getVariableNames().isEmpty());
        Assertions.assertNotNull((Object)tec.getTemplateInstance());
        Assertions.assertFalse((boolean)tec.containsVariable("XYZ"));
        Assertions.assertNull((Object)tec.getVariable("XYZ"));
    }
}

