/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.template.engine.test.service.exceptions;

import cat.albirar.template.engine.ITemplateEngineFactory;
import cat.albirar.template.engine.models.TemplateDefinitionBean;
import cat.albirar.template.engine.models.TemplateInstanceBean;
import cat.albirar.template.engine.service.TemplateNotAccessibleException;
import cat.albirar.template.engine.test.configuration.DefaultTestConfiguration;
import cat.albirar.template.engine.test.service.AbstractTest;
import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={DefaultTestConfiguration.class})
public class TemplateEngineExceptionsTest
extends AbstractTest {
    @Autowired
    private ITemplateEngineFactory render;
    @Autowired
    private ApplicationContext applicationContext;

    @Test
    public void when_templateIsOfUnkownLanguage_then_anIllegalStateExceptionIsThrown() {
        TemplateInstanceBean tInstance = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleHtmlTemplateDefinition.toBuilder().templateEngineLanguage("XXX").build()).build();
        Assertions.assertThrows(IllegalStateException.class, () -> this.render.renderTemplate(tInstance));
    }

    @Test
    public void when_templateDoesntExists_then_aTemplateNotAccessibleExceptionIsThrown() {
        TemplateInstanceBean tInstance = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleHtmlTemplateDefinition.toBuilder().template("/test-template.html").build()).build();
        Assertions.assertThrows(TemplateNotAccessibleException.class, () -> this.render.renderTemplate(tInstance));
    }

    @Test
    public void when_templateIsNotAFile_then_aTemplateNotAccessibleExceptionIsThrown() throws Exception {
        Resource r = this.applicationContext.getResource("classpath:" + this.getClass().getPackage().getName().replace(".", File.separator));
        Assertions.assertTrue((boolean)r.exists());
        Assertions.assertTrue((!r.getFile().isFile() ? 1 : 0) != 0);
        TemplateInstanceBean tInstance = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleHtmlTemplateDefinition.toBuilder().template("/").build()).build();
        Assertions.assertThrows(TemplateNotAccessibleException.class, () -> this.render.renderTemplate(tInstance));
    }

    @Test
    public void when_templateThereAreNotAuthorizationToReadThem_then_aTemplateNotAccessibleExceptionIsThrown() throws Exception {
        File file = this.applicationContext.getResource(simpleHtmlTemplateDefinition.getTemplate()).getFile();
        file.setReadable(false);
        TemplateInstanceBean tInstance = TemplateInstanceBean.buildInstance((TemplateDefinitionBean)simpleHtmlTemplateDefinition.toBuilder().build()).build();
        Assertions.assertThrows(TemplateNotAccessibleException.class, () -> this.render.renderTemplate(tInstance));
        file.setReadable(true);
    }
}

