/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.arquillian;

import ch.abertschi.arquillian.AjCompiler$$Lambda$1;
import ch.abertschi.arquillian.AjCompiler$$Lambda$2;
import ch.abertschi.arquillian.AjCompiler$$Lambda$3;
import ch.abertschi.arquillian.AjCompiler$$Lambda$4;
import ch.abertschi.arquillian.util.ResolverUtil;
import com.github.underscore.$;
import com.github.underscore.Block;
import com.github.underscore.Function1;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.tools.ajc.Main;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(AjCompiler.class);
    private static final String AJRT = "org.aspectj:aspectjrt:1.8.9";

    protected List<String> getInitialOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint:ignore");
        options.add("-showWeaveInfo");
        return options;
    }

    public List<Archive<?>> getRuntimeLibraries() {
        return ((MavenFormatStage)ResolverUtil.get().resolve(AJRT).withTransitivity()).asList(JavaArchive.class);
    }

    public Archive<?> compileTimeWeave(List<Archive<?>> weavingLibraries, List<Archive<?>> aspectLibraries) {
        List<String> options = this.getInitialOptions();
        File base = new File(new File("."), "./target/aj");
        base.mkdirs();
        options.add("-d");
        options.add(base.getAbsolutePath());
        String weaved = "./target/weaved.jar";
        File weavedFile = new File(new File("."), weaved);
        options.add("-outjar");
        options.add(weavedFile.getAbsolutePath());
        File weavingBase = new File(new File("."), "./target/ajc");
        List<File> inPaths = this.exportAsZip(weavingLibraries, weavingBase);
        String inPath = $.join((Iterable)$.map(inPaths, (Function1)AjCompiler$$Lambda$1.lambdaFactory$()), (String)File.pathSeparator);
        options.add("-inpath");
        options.add(inPath);
        File aspectBase = new File(new File("."), "./target/aspects");
        List<File> aspectFiles = this.exportAsZip(aspectLibraries, aspectBase);
        String aspects = $.join((Iterable)$.map(aspectFiles, (Function1)AjCompiler$$Lambda$2.lambdaFactory$()), (String)File.pathSeparator);
        options.add("-aspectpath");
        options.add(aspects);
        LOG.debug("Calling aj compiler with " + $.join(options, (String)" "));
        Main compiler = new Main();
        MessageHandler m = new MessageHandler();
        compiler.run(options.toArray(new String[options.size()]), (IMessageHolder)m);
        IMessage[] ms = m.getMessages(null, true);
        $.forEach(Arrays.asList(ms), (Block)AjCompiler$$Lambda$3.lambdaFactory$());
        return this.importFromZip(weavedFile);
    }

    public Archive<?> compileTimeWeave(Archive<?> weavingLibrary, List<Archive<?>> aspectLibraries) {
        ArrayList libs = new ArrayList();
        libs.add(weavingLibrary);
        return this.compileTimeWeave(libs, aspectLibraries);
    }

    public Archive<?> compileTimeWeave(Archive<?> weavingLibrary, Archive<?> aspectLib) {
        ArrayList libs = new ArrayList();
        libs.add(aspectLib);
        return this.compileTimeWeave(weavingLibrary, libs);
    }

    private JavaArchive importFromZip(File where) {
        try {
            return (JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class)).importFrom(where.toURI().toURL().openStream())).as(JavaArchive.class);
        }
        catch (IOException e) {
            String msg = String.format("%s can not be found", where.getAbsolutePath());
            throw new RuntimeException(msg);
        }
    }

    private File exportAsZip(Archive<?> archive, File basepath) {
        File f = new File(basepath, archive.getName());
        basepath.mkdirs();
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(f, true);
        return f;
    }

    private List<File> exportAsZip(List<Archive<?>> archives, File basepath) {
        return $.map(archives, (Function1)AjCompiler$$Lambda$4.lambdaFactory$(this, basepath));
    }

    private /* synthetic */ File lambda$exportAsZip$16(File basepath, Archive archive) {
        return this.exportAsZip(archive, basepath);
    }

    static /* synthetic */ String access$lambda$0(File file) {
        return file.getAbsolutePath();
    }

    static /* synthetic */ String access$lambda$1(File file) {
        return file.getAbsolutePath();
    }

    static /* synthetic */ void access$lambda$2(IMessage iMessage) {
        AjCompiler.LOG.debug(iMessage.getMessage());
    }

    static /* synthetic */ File access$lambda$3(AjCompiler ajCompiler, File file, Archive archive) {
        return ajCompiler.lambda$exportAsZip$16(file, archive);
    }
}

