/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.arquillian;

import ch.abertschi.arquillian.AjCompiler;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$1;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$2;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$3;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$4;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$5;
import ch.abertschi.arquillian.ArchiveSearch;
import ch.abertschi.arquillian.Cache;
import ch.abertschi.arquillian.descriptor.model.AspectLibrary;
import ch.abertschi.arquillian.descriptor.model.AspectjDescriptorModel;
import ch.abertschi.arquillian.descriptor.model.WeavingLibrary;
import ch.abertschi.arquillian.util.MatcherUtils;
import ch.abertschi.arquillian.util.ResolverUtil;
import com.github.underscore.$;
import com.github.underscore.Block;
import com.github.underscore.Function1;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.javatuples.Pair;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveProcessor.class);
    private static final String CONFIG_FILE = "/META-INF/aspectj.json";
    private static final AjCompiler COMPILER = new AjCompiler();

    public void process(Archive<?> deployableArchive, TestClass testClass) {
        AspectjDescriptorModel model = this.getConfigurationFromArchive(deployableArchive);
        if (!$.isNull((Object)model)) {
            for (WeavingLibrary weavingDescriptor : model.getWeaving()) {
                List<Pair<ArchiveSearch.ArchiveSearchResult, Archive>> weavings = this.getWeavingLibraries(deployableArchive, weavingDescriptor);
                List<Archive<?>> aspects = this.getAspectLibraries(deployableArchive, weavingDescriptor.getAspects());
                for (Pair<ArchiveSearch.ArchiveSearchResult, Archive> weave : weavings) {
                    Archive<?> compiled = this.compile((Archive)weave.getValue1(), aspects, weavingDescriptor);
                    $.forEach(compiled.getContent().entrySet(), (Block)ArchiveProcessor$$Lambda$1.lambdaFactory$());
                    Archive replace = ((ArchiveSearch.ArchiveSearchResult)weave.getValue0()).getArchive().merge(compiled);
                    for (Archive aspect : $.concat(COMPILER.getRuntimeLibraries(), (Iterable[])new Iterable[]{aspects})) {
                        replace = replace.merge(aspect);
                    }
                    ArchiveSearch.replaceArchive(deployableArchive, ((ArchiveSearch.ArchiveSearchResult)weave.getValue0()).getPath(), replace);
                }
            }
        }
    }

    private Archive<?> compile(Archive<?> source, List<Archive<?>> aspects, WeavingLibrary descriptor) {
        if (descriptor.isUseCache()) {
            Archive<?> cached = Cache.getFromCache(source);
            if (cached == null) {
                LOG.info(String.format("Recompiling weaving library %s", source.getName()));
                Archive<?> compiled = COMPILER.compileTimeWeave(source, aspects);
                Cache.storeInCache(source, compiled);
                return compiled;
            }
            LOG.info(String.format("Skipping aspectj compilation. Using cached archive %s from %s", source.getName(), Cache.getCacheBaseDir()));
            return cached;
        }
        LOG.info(String.format("Recompiling weaving library %s", source.getName()));
        return COMPILER.compileTimeWeave(source, aspects);
    }

    private List<Archive<?>> getAspectLibraries(Archive<?> sourceArchive, List<AspectLibrary> aspectDescriptors) {
        ArrayList returns = new ArrayList();
        for (AspectLibrary aspectDescriptor : aspectDescriptors) {
            List aspects;
            if (aspectDescriptor.getName().contains(":")) {
                aspects = ((MavenFormatStage)ResolverUtil.get().resolve(aspectDescriptor.getName()).withTransitivity()).asList(JavaArchive.class);
            } else {
                String searchPattern = MatcherUtils.transformToMatchAnyParent(aspectDescriptor.getName());
                aspects = $.map(ArchiveSearch.searchInArchive(sourceArchive, searchPattern, false), (Function1)ArchiveProcessor$$Lambda$2.lambdaFactory$());
            }
            if ($.isEmpty((Iterable)aspects)) {
                String msg = String.format("aspect %s was neither found in deployable archive nor in maven repository", aspectDescriptor.getName());
                throw new RuntimeException(msg);
            }
            List<String> aspectIncludes = MatcherUtils.transformToMatchAnyChild(aspectDescriptor.getIncludes());
            List<String> aspectExcludes = MatcherUtils.transformToMatchAnyChild(aspectDescriptor.getExcludes());
            for (Archive aspect : aspects) {
                returns.add(ArchiveSearch.filterArchive(aspect, aspectIncludes, aspectExcludes));
            }
        }
        $.forEach(returns, (Block)ArchiveProcessor$$Lambda$3.lambdaFactory$());
        return Collections.unmodifiableList(returns);
    }

    private List<Pair<ArchiveSearch.ArchiveSearchResult, Archive>> getWeavingLibraries(Archive<?> sourceArchive, WeavingLibrary weavingDescriptor) {
        String pattern = weavingDescriptor.isWeaveEverything() ? sourceArchive.getName() : MatcherUtils.transformToMatchAnyParent(weavingDescriptor.getName());
        ArrayList<Pair> returns = new ArrayList<Pair>();
        List<ArchiveSearch.ArchiveSearchResult> weavings = ArchiveSearch.searchInArchive(sourceArchive, pattern, false);
        if (!$.isEmpty(weavings)) {
            for (ArchiveSearch.ArchiveSearchResult weaving : weavings) {
                List<String> includes = MatcherUtils.transformToMatchAnyChild(weavingDescriptor.getIncludes());
                List<String> excludes = MatcherUtils.transformToMatchAnyChild(weavingDescriptor.getExcludes());
                Archive<?> filtered = ArchiveSearch.filterArchive(weaving.getArchive(), includes, excludes);
                returns.add(new Pair((Object)weaving, filtered));
            }
        } else {
            String msg = String.format("Weaving %s could not be found in deployable", weavingDescriptor.getName());
            throw new RuntimeException(msg);
        }
        $.forEach(returns, (Block)ArchiveProcessor$$Lambda$4.lambdaFactory$());
        return Collections.unmodifiableList(returns);
    }

    private AspectjDescriptorModel getConfigurationFromArchive(Archive<?> archive) {
        Node configNode = archive.get(CONFIG_FILE);
        if (configNode != null) {
            String json;
            try {
                json = IOUtils.toString((InputStream)configNode.getAsset().openStream(), (String)"UTF-8");
                LOG.debug(json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (json != null) {
                return this.parseConfiguration(json);
            }
        }
        return null;
    }

    private AspectjDescriptorModel parseConfiguration(String json) {
        AspectjDescriptorModel model = null;
        if (json != null) {
            ObjectMapper mapper = new ObjectMapper().setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
            try {
                model = (AspectjDescriptorModel)mapper.readValue(json, AspectjDescriptorModel.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Error in parsing aspectj.json", e);
            }
        }
        return model;
    }

    private void addAsLibraryOrMerge(Archive<?> base, List<Archive> toAdd) {
        if (base instanceof LibraryContainer) {
            ((LibraryContainer)base).addAsLibraries(toAdd);
        } else {
            $.forEach(toAdd, (Block)ArchiveProcessor$$Lambda$5.lambdaFactory$(base));
        }
    }

    static /* synthetic */ void access$lambda$0(Map.Entry entry) {
        ArchiveProcessor.LOG.trace("Compiled node: " + entry.getKey());
    }

    static /* synthetic */ Archive access$lambda$1(ArchiveSearch.ArchiveSearchResult archiveSearchResult) {
        return archiveSearchResult.getArchive();
    }

    static /* synthetic */ void access$lambda$2(Archive archive) {
        ArchiveProcessor.LOG.info(String.format("Found aspect library %s", archive.getName()));
    }

    static /* synthetic */ void access$lambda$3(Pair pair) {
        ArchiveProcessor.LOG.info(String.format("Found weaving library %s", ((ArchiveSearch.ArchiveSearchResult)pair.getValue0()).getPath()));
    }

    static /* synthetic */ void access$lambda$4(Archive archive, Archive archive2) {
        archive.merge(archive2);
    }
}

