/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.arquillian;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;

public class Cache {
    private static final String TEMP_DIR = "java.io.tmpdir";
    private static final String CACHE_DIR = "arquillian-aspectj-extention-cache";
    private static final String CACHE_INDEX = "cache-index.xml";
    private static final XStream XSTREAM = new XStream();

    public static File getCacheBaseDir() {
        String tmpDir = System.getProperty(TEMP_DIR);
        File cacheDir = new File(tmpDir, CACHE_DIR);
        cacheDir.mkdirs();
        return cacheDir;
    }

    protected static File getCacheIndexFile() {
        return new File(Cache.getCacheBaseDir(), CACHE_INDEX);
    }

    public static String getChecksum(Archive<?> archive) {
        try {
            return Integer.toString(IOUtils.toByteArray((InputStream)((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream()).length);
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create checksum of archive " + archive.getName(), e);
        }
    }

    public static Archive<?> getFromCache(Archive<?> keyArchive) {
        String checksum = Cache.getChecksum(keyArchive);
        Map<String, String> storage = Cache.loadCacheIndex();
        String cached = storage.get(checksum);
        if (cached == null) {
            return null;
        }
        File cachedFile = new File(cached);
        if (!cachedFile.exists()) {
            return null;
        }
        return (Archive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class)).importFrom(cachedFile)).as(GenericArchive.class);
    }

    protected static void storeInCache(Archive<?> keyArchive, Archive<?> archiveToCache) {
        String checksum = Cache.getChecksum(keyArchive);
        File persist = new File(Cache.getCacheBaseDir(), checksum + "-" + archiveToCache.getName());
        ((ZipExporter)archiveToCache.as(ZipExporter.class)).exportTo(persist, true);
        Cache.addToCacheIndex(checksum, persist.getAbsolutePath());
    }

    protected static Map<String, String> loadCacheIndex() {
        Map<String, String> cacheIndex = new HashMap<String, String>();
        File cacheIndexFile = Cache.getCacheIndexFile();
        if (cacheIndexFile.exists()) {
            cacheIndex = (Map)XSTREAM.fromXML(cacheIndexFile);
        }
        return cacheIndex;
    }

    protected static void addToCacheIndex(String key, String value) {
        Map<String, String> cacheIndex = Cache.loadCacheIndex();
        cacheIndex.put(key, value);
        File cacheIndexFile = Cache.getCacheIndexFile();
        try {
            FileOutputStream out = new FileOutputStream(cacheIndexFile);
            XSTREAM.toXML(cacheIndex, (OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

