/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.arquillian;

import ch.abertschi.arquillian.ArchiveSearch$$Lambda$1;
import ch.abertschi.arquillian.ArchiveSearch$$Lambda$2;
import com.github.underscore.$;
import com.github.underscore.Function1;
import com.github.underscore.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class ArchiveSearch {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveSearch.class);
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    private static List<String> SUPPORTED_NESTED_CONTAINERS = Arrays.asList(".jar", ".war");

    public static List<ArchiveSearchResult> searchInArchive(Archive<?> archive, String pattern, boolean matchMultiple) {
        String name;
        ArrayList<ArchiveSearchResult> returns = new ArrayList<ArchiveSearchResult>();
        if (MATCHER.match(pattern = ArchiveSearch.preparePattern(pattern), name = "/" + archive.getName())) {
            ArchiveSearchResult result = new ArchiveSearchResult().setPath(name).setArchive(archive).setParentArchive(null);
            LOG.debug(String.format("Archive [%s] found with matching pattern %s", name, pattern));
            returns.add(result);
        }
        if (matchMultiple || $.isEmpty(returns)) {
            returns.addAll(ArchiveSearch._searchInArchive(archive, name, pattern, matchMultiple));
        }
        return returns;
    }

    private static List<ArchiveSearchResult> _searchInArchive(Archive<?> archive, String basepath, String pattern, boolean matchMultiple) {
        ArrayList<ArchiveSearchResult> returns = new ArrayList<ArchiveSearchResult>();
        for (Map.Entry entry : archive.getContent().entrySet()) {
            List<ArchiveSearchResult> subResults;
            GenericArchive subArchive;
            String path = basepath + ((ArchivePath)entry.getKey()).get().toString();
            LOG.debug(String.format("Searching [%s] in [%s]", pattern, path));
            if (MATCHER.match(pattern, path)) {
                subArchive = ArchiveSearch.convertToArchive(((Node)entry.getValue()).getAsset());
                ArchiveSearchResult result = new ArchiveSearchResult().setPath(path).setArchive((Archive<?>)subArchive).setParentArchive(archive);
                LOG.debug(String.format("Asset [%s] found with matching pattern %s", path, pattern));
                returns.add(result);
                if (!matchMultiple) break;
            }
            if (!ArchiveSearch.isNestedContainer(path) || $.isEmpty(subResults = ArchiveSearch._searchInArchive(subArchive = ArchiveSearch.convertToArchive(((Node)entry.getValue()).getAsset()), path, pattern, matchMultiple))) continue;
            returns.addAll(subResults);
            if (matchMultiple) continue;
            break;
        }
        return returns;
    }

    public static Archive<?> filterArchive(Archive<?> archive, List<String> includes, List<String> excludes) {
        includes = ArchiveSearch.preparePatterns(includes);
        excludes = ArchiveSearch.preparePatterns(excludes);
        boolean hasIncludeFilter = !$.isEmpty(includes);
        boolean hasExcludeFilter = !$.isEmpty(excludes);
        Archive filteredArchive = archive.shallowCopy();
        if (hasIncludeFilter || hasExcludeFilter) {
            for (Map.Entry entry : archive.getContent().entrySet()) {
                boolean isFile = ((Node)entry.getValue()).getAsset() != null;
                if (!isFile) continue;
                String asset = ((ArchivePath)entry.getKey()).get();
                if ((!hasIncludeFilter || ArchiveSearch.matchesPattern(asset, includes)) && (!hasExcludeFilter || !ArchiveSearch.matchesPattern(asset, excludes))) continue;
                LOG.debug("Removing from " + archive.getName() + " " + entry.getKey());
                filteredArchive.delete((ArchivePath)entry.getKey());
            }
        }
        return filteredArchive;
    }

    public static Archive<?> replaceArchive(Archive<?> archive, String searchKey, Archive<?> replace) {
        String basename;
        if ((searchKey = ArchiveSearch.preparePattern(searchKey)).equals(basename = "/" + archive.getName())) {
            archive.merge(replace);
            return archive;
        }
        Archive<?> replaced = ArchiveSearch._replaceArchive(archive, searchKey, basename, replace);
        if ($.isNull(replaced)) {
            String msg = String.format("No entry found with Node %s to replace in %s", searchKey, basename);
            throw new RuntimeException(msg);
        }
        return replaced;
    }

    private static String getArchiveName(ArchivePath path) {
        String[] split = path.get().split("/");
        return split[split.length - 1];
    }

    private static Archive<?> _replaceArchive(Archive<?> parentArchive, String key, String basepath, Archive<?> replace) {
        Archive<?> match = null;
        for (Map.Entry entry : parentArchive.getContent().entrySet()) {
            GenericArchive subArchive;
            Archive<?> subReplace;
            String path = basepath + ((ArchivePath)entry.getKey()).get().toString();
            if (key.equals(path)) {
                LOG.debug(String.format("Replacing %s with %s", key, replace.getName()));
                parentArchive.delete((ArchivePath)entry.getKey());
                String name = ArchiveSearch.getArchiveName((ArchivePath)entry.getKey());
                GenericArchive merge = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)name)).merge(replace);
                parentArchive.add((Archive)merge, ((ArchivePath)entry.getKey()).getParent(), ZipExporter.class);
                match = parentArchive;
                break;
            }
            if (!key.contains(path) || !ArchiveSearch.isNestedContainer(path) || $.isNull(subReplace = ArchiveSearch._replaceArchive(subArchive = ArchiveSearch.convertToArchive(((Node)entry.getValue()).getAsset()), key, path, replace))) continue;
            LOG.debug(String.format("Replacing %s with %s", key, replace.getName()));
            parentArchive.delete((ArchivePath)entry.getKey());
            parentArchive.add(subReplace, (ArchivePath)entry.getKey(), ZipExporter.class);
            match = parentArchive;
            break;
        }
        return match;
    }

    public static boolean matchesPattern(String path, List<String> patterns) {
        boolean matches = false;
        for (String pat : patterns) {
            if (!MATCHER.match(pat, path)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private static boolean isNestedContainer(String name) {
        return !$.isEmpty((Iterable)$.filter(SUPPORTED_NESTED_CONTAINERS, (Predicate)ArchiveSearch$$Lambda$1.lambdaFactory$(name)));
    }

    private static GenericArchive convertToArchive(Asset asset) {
        return (GenericArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class)).importFrom(asset.openStream())).as(GenericArchive.class);
    }

    private static String preparePattern(String pattern) {
        return !pattern.startsWith("/") ? "/" + pattern : pattern;
    }

    private static List<String> preparePatterns(List<String> patterns) {
        return $.map(patterns, (Function1)ArchiveSearch$$Lambda$2.lambdaFactory$());
    }

    static /* synthetic */ Boolean access$lambda$0(String string, String string2) {
        return string.endsWith(string2);
    }

    static /* synthetic */ String access$lambda$1(String string) {
        return ArchiveSearch.preparePattern(string);
    }

    public static class ArchiveSearchResult {
        private Archive<?> parentArchive;
        private String path;
        private Archive<?> archive;

        public Archive<?> getArchive() {
            return this.archive;
        }

        public ArchiveSearchResult setArchive(Archive<?> archive) {
            this.archive = archive;
            return this;
        }

        public Archive<?> getParentArchive() {
            return this.parentArchive;
        }

        public ArchiveSearchResult setParentArchive(Archive<?> parentArchive) {
            this.parentArchive = parentArchive;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public ArchiveSearchResult setPath(String path) {
            this.path = path;
            return this;
        }
    }
}

