/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.authorization.impl;

import ch.admin.bag.covidcertificate.authorization.AuthorizationConfig;
import ch.admin.bag.covidcertificate.authorization.AuthorizationService;
import ch.admin.bag.covidcertificate.authorization.config.RoleConfig;
import ch.admin.bag.covidcertificate.authorization.config.RoleData;
import ch.admin.bag.covidcertificate.authorization.config.ServiceData;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Profile(value={"authorization && !mock-authorization"})
public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationServiceImpl.class);
    private final AuthorizationConfig authorizationConfig;
    private final RoleConfig roleConfig;
    private Map<String, ServiceData> services;
    private Map<String, String> roleMapping;

    @Override
    public Set<String> getCurrent(String service, List<String> rawRoles) {
        Set<String> grantedFunctions = Collections.emptySet();
        ServiceData serviceData = this.services.get(service);
        if (serviceData == null) {
            log.info("service '{}' unknown", (Object)service);
        } else {
            Set<String> roles = this.mapRawRoles(rawRoles);
            if (roles.isEmpty()) {
                log.info("no supported roles in '{}'", rawRoles);
            } else {
                Map<String, ServiceData.Function> functions = serviceData.getFunctions();
                List<ServiceData.Function> functionsByPointInTime = this.filterByPointInTime(LocalDateTime.now(), functions.values());
                grantedFunctions = functionsByPointInTime.stream().filter(function -> this.isGrantedIntern(roles, (ServiceData.Function)function)).map(ServiceData.Function::getIdentifier).collect(Collectors.toSet());
            }
        }
        log.info("grants: " + grantedFunctions);
        return grantedFunctions;
    }

    @Override
    public ServiceData getDefinition(String service) {
        return this.services.get(service);
    }

    @Override
    public List<RoleData> getRoleMapping() {
        return this.roleConfig.getMappings();
    }

    @Override
    public boolean isGranted(Set<String> rawRoles, ServiceData.Function function) {
        Set<String> roles = this.mapRawRoles(rawRoles);
        return this.isGrantedIntern(roles, function);
    }

    private boolean isGrantedIntern(Set<String> roles, ServiceData.Function function) {
        List<String> oneOf;
        boolean isActive = function.isBetween(LocalDateTime.now());
        if (!isActive) {
            return false;
        }
        boolean allAdditionalValid = true;
        if (CollectionUtils.isNotEmpty(function.getAdditional())) {
            List<ServiceData.Function> activeAdditionalFunctions = this.filterByPointInTime(LocalDateTime.now(), function.getAdditional());
            allAdditionalValid = activeAdditionalFunctions.stream().allMatch(func -> this.isGrantedIntern(roles, (ServiceData.Function)func));
        }
        if (CollectionUtils.isEmpty(oneOf = function.getOneOf())) {
            return allAdditionalValid;
        }
        boolean oneOfValid = oneOf.stream().anyMatch(roles::contains);
        return allAdditionalValid && oneOfValid;
    }

    @Override
    public boolean isUserPermitted(Collection<String> rawRoles) {
        boolean isHinCodeOrPersonal;
        boolean userIsPermitted = true;
        boolean isHinUser = rawRoles.contains("bag-cc-hin-epr") || rawRoles.contains("bag-cc-hin");
        boolean bl = isHinCodeOrPersonal = rawRoles.contains("bag-cc-hincode") || rawRoles.contains("bag-cc-personal");
        if (isHinUser && !isHinCodeOrPersonal) {
            log.warn("HIN-User not allowed to use the application...");
            log.warn("userroles: {}", rawRoles);
            userIsPermitted = false;
        }
        return userIsPermitted;
    }

    @Override
    public List<ServiceData.Function> identifyFunction(String service, String uri, String httpMethod) {
        List<ServiceData.Function> functions = this.getDefinition(service).getFunctions().values().stream().filter(f -> StringUtils.hasText((String)f.getUri())).filter(f -> f.matchesUri(uri)).filter(f -> f.matchesHttpMethod(httpMethod)).filter(f -> f.isBetween(LocalDateTime.now())).toList();
        return functions;
    }

    @Override
    public Set<String> mapRawRoles(Collection<String> rawRoles) {
        return rawRoles.stream().map(role -> this.roleMapping.get(role)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private List<ServiceData.Function> filterByPointInTime(LocalDateTime pointInTime, Collection<ServiceData.Function> functions) {
        List<ServiceData.Function> result = Collections.emptyList();
        if (functions != null && pointInTime != null) {
            result = ((Stream)functions.stream().parallel()).filter(function -> function.isBetween(pointInTime)).toList();
        }
        return result;
    }

    @PostConstruct
    void init() {
        this.services = new TreeMap<String, ServiceData>();
        this.services.put("notifications", this.enrichServiceData(this.authorizationConfig.getNotifications()));
        this.services.put("api-gateway", this.enrichServiceData(this.authorizationConfig.getApiGateway()));
        this.services.put("management", this.enrichServiceData(this.authorizationConfig.getManagement()));
        this.services.put("web-ui", this.enrichServiceData(this.authorizationConfig.getWebUi()));
        this.services.put("report", this.enrichServiceData(this.authorizationConfig.getReport()));
        this.roleMapping = new TreeMap<String, String>();
        for (RoleData roleData : this.roleConfig.getMappings()) {
            if (this.roleMapping.containsKey(roleData.getClaim()) || this.roleMapping.containsKey(roleData.getEiam())) {
                throw new IllegalStateException(MessageFormat.format("role mappings for \"{0}\" not unique (conflicts with either eiam \"{1}\" or claim \"{2}\")", roleData.getIntern(), roleData.getEiam(), roleData.getClaim()));
            }
            this.roleMapping.put(roleData.getClaim(), roleData.getIntern());
            this.roleMapping.put(roleData.getEiam(), roleData.getIntern());
        }
    }

    private ServiceData enrichServiceData(ServiceData serviceData) {
        if (serviceData == null) {
            return null;
        }
        serviceData.getFunctions().values().forEach(function -> this.enrichFunction((ServiceData.Function)function, serviceData.getFunctions()));
        return serviceData;
    }

    private void enrichFunction(ServiceData.Function function, Map<String, ServiceData.Function> repo) {
        function.setAdditional(this.buildAdditionalList(function.getAdditionalRef(), repo));
        if (function.getOneOf() == null) {
            function.setOneOf(Collections.emptyList());
        }
    }

    private List<ServiceData.Function> buildAdditionalList(List<String> refs, Map<String, ServiceData.Function> repo) {
        ArrayList<ServiceData.Function> result = new ArrayList<ServiceData.Function>();
        if (refs != null) {
            for (String ref : refs) {
                ServiceData.Function func = repo.get(ref);
                if (func != null) {
                    result.add(func);
                    continue;
                }
                throw new IllegalStateException(MessageFormat.format("referenced Function in Authorization Config not found: \"{0}\"", ref));
            }
        }
        return result;
    }

    public AuthorizationServiceImpl(AuthorizationConfig authorizationConfig, RoleConfig roleConfig) {
        this.authorizationConfig = authorizationConfig;
        this.roleConfig = roleConfig;
    }
}

