/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.authorization.config;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.http.HttpMethod;

public class ServiceData {
    @NestedConfigurationProperty
    private Map<String, Function> functions = new HashMap<String, Function>();

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Map<String, Function> functions) {
        this.functions = functions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceData)) {
            return false;
        }
        ServiceData other = (ServiceData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Function> this$functions = this.getFunctions();
        Map<String, Function> other$functions = other.getFunctions();
        return !(this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Function> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceData(functions=" + this.getFunctions() + ")";
    }

    public static class Function {
        private String identifier;
        private String uri;
        private LocalDateTime from;
        private LocalDateTime until;
        private List<String> additionalRef;
        private List<Function> additional;
        private List<String> oneOf;
        private List<HttpMethod> http;

        public boolean isBetween(LocalDateTime pointInTime) {
            boolean fromSmallerEquals = this.getFrom() == null || this.getFrom().isBefore(pointInTime) || this.getFrom().isEqual(pointInTime);
            boolean untilLargerEquals = this.getUntil() == null || this.getUntil().isAfter(pointInTime) || this.getUntil().isEqual(pointInTime);
            return fromSmallerEquals && untilLargerEquals;
        }

        public boolean matchesUri(String uri) {
            String[] pathsToCompare;
            String[] paths = this.uri.split("/");
            if (paths.length != (pathsToCompare = uri.split("/")).length) {
                return false;
            }
            return IntStream.range(0, paths.length).map(i -> paths.length - 1 - i).filter(i -> !paths[i].startsWith("{") && !paths[i].endsWith("}")).allMatch(i -> Objects.equals(paths[i], pathsToCompare[i]));
        }

        public boolean matchesHttpMethod(String method) {
            return CollectionUtils.isEmpty(this.http) || this.http.stream().anyMatch(m -> m.matches(method.toUpperCase(Locale.ROOT)));
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getUri() {
            return this.uri;
        }

        public LocalDateTime getFrom() {
            return this.from;
        }

        public LocalDateTime getUntil() {
            return this.until;
        }

        public List<String> getAdditionalRef() {
            return this.additionalRef;
        }

        public List<Function> getAdditional() {
            return this.additional;
        }

        public List<String> getOneOf() {
            return this.oneOf;
        }

        public List<HttpMethod> getHttp() {
            return this.http;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setFrom(LocalDateTime from) {
            this.from = from;
        }

        public void setUntil(LocalDateTime until) {
            this.until = until;
        }

        public void setAdditionalRef(List<String> additionalRef) {
            this.additionalRef = additionalRef;
        }

        public void setAdditional(List<Function> additional) {
            this.additional = additional;
        }

        public void setOneOf(List<String> oneOf) {
            this.oneOf = oneOf;
        }

        public void setHttp(List<HttpMethod> http) {
            this.http = http;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Function)) {
                return false;
            }
            Function other = (Function)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            LocalDateTime this$from = this.getFrom();
            LocalDateTime other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            LocalDateTime this$until = this.getUntil();
            LocalDateTime other$until = other.getUntil();
            if (this$until == null ? other$until != null : !((Object)this$until).equals(other$until)) {
                return false;
            }
            List<String> this$additionalRef = this.getAdditionalRef();
            List<String> other$additionalRef = other.getAdditionalRef();
            if (this$additionalRef == null ? other$additionalRef != null : !((Object)this$additionalRef).equals(other$additionalRef)) {
                return false;
            }
            List<Function> this$additional = this.getAdditional();
            List<Function> other$additional = other.getAdditional();
            if (this$additional == null ? other$additional != null : !((Object)this$additional).equals(other$additional)) {
                return false;
            }
            List<String> this$oneOf = this.getOneOf();
            List<String> other$oneOf = other.getOneOf();
            if (this$oneOf == null ? other$oneOf != null : !((Object)this$oneOf).equals(other$oneOf)) {
                return false;
            }
            List<HttpMethod> this$http = this.getHttp();
            List<HttpMethod> other$http = other.getHttp();
            return !(this$http == null ? other$http != null : !((Object)this$http).equals(other$http));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Function;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            LocalDateTime $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            LocalDateTime $until = this.getUntil();
            result = result * 59 + ($until == null ? 43 : ((Object)$until).hashCode());
            List<String> $additionalRef = this.getAdditionalRef();
            result = result * 59 + ($additionalRef == null ? 43 : ((Object)$additionalRef).hashCode());
            List<Function> $additional = this.getAdditional();
            result = result * 59 + ($additional == null ? 43 : ((Object)$additional).hashCode());
            List<String> $oneOf = this.getOneOf();
            result = result * 59 + ($oneOf == null ? 43 : ((Object)$oneOf).hashCode());
            List<HttpMethod> $http = this.getHttp();
            result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
            return result;
        }

        public String toString() {
            return "ServiceData.Function(identifier=" + this.getIdentifier() + ", uri=" + this.getUri() + ", from=" + this.getFrom() + ", until=" + this.getUntil() + ", additionalRef=" + this.getAdditionalRef() + ", additional=" + this.getAdditional() + ", oneOf=" + this.getOneOf() + ", http=" + this.getHttp() + ")";
        }
    }
}

