/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.log.async;

import ch.admin.bag.covidcertificate.log.async.FallbackAppenderRef;
import ch.admin.bag.covidcertificate.log.metrics.LoggingMetrics;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AsyncAppenderBase;

public class AsyncBufferFullFallbackAppender
extends AsyncAppenderBase<ILoggingEvent> {
    private static final int UNDEFINED = -1;
    private boolean useFallbackAppender = true;
    private int fallbackThreshold = -1;
    private FallbackAppenderRef fallback;

    public AsyncBufferFullFallbackAppender() {
        this.setDiscardingThreshold(0);
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.useFallbackAppender && this.isBufferNearlyFull()) {
            LoggingMetrics.incrementAsyncBufferFullFallback();
            this.fallback.appendToFallbackAppender(eventObject, "Async buffer full");
        } else {
            this.fallback.notifyFallbackDeactivated();
            super.append((Object)eventObject);
        }
    }

    private boolean isBufferNearlyFull() {
        return this.getRemainingCapacity() <= this.fallbackThreshold;
    }

    protected void preprocess(ILoggingEvent eventObject) {
        eventObject.prepareForDeferredProcessing();
    }

    public void start() {
        if (this.fallbackThreshold == -1) {
            this.fallbackThreshold = this.getQueueSize() / 5;
        }
        this.fallback.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.fallback.stop();
    }

    public void setUseFallbackAppender(boolean useFallbackAppender) {
        this.useFallbackAppender = useFallbackAppender;
    }

    public void setFallbackThreshold(int fallbackThreshold) {
        this.fallbackThreshold = fallbackThreshold;
    }

    public void setFallback(FallbackAppenderRef fallback) {
        this.fallback = fallback;
    }
}

