/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.log.syslog.connection;

import ch.admin.bag.covidcertificate.log.metrics.LoggingMetrics;
import ch.admin.bag.covidcertificate.log.syslog.connection.ConnectionState;
import ch.qos.logback.core.net.ssl.SSLConfigurable;
import ch.qos.logback.core.net.ssl.SSLConfigurableSocket;
import ch.qos.logback.core.net.ssl.SSLConfiguration;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class TLSSyslogConnection {
    private SSLSocket clientSocket;
    private final String syslogHost;
    private final int port;
    private final SSLContext sslContext;
    private final SSLParametersConfiguration sslParameters;
    private final int timeoutMillis;
    private final ConnectionState connectionState = ConnectionState.disconnected();
    private boolean connectionLoggedOnce = false;
    private String lastTransmitError;

    public static TLSSyslogConnection create(String syslogHost, int port, SSLConfiguration ssl, ContextAware context, int timeoutMillis) throws GeneralSecurityException {
        SSLContext sslContext = ssl.createContext(context);
        SSLParametersConfiguration parameters = ssl.getParameters();
        parameters.setContext(context.getContext());
        return new TLSSyslogConnection(syslogHost, port, sslContext, parameters, timeoutMillis);
    }

    public boolean transmit(byte[] syslogMessage) {
        if (this.connectionState.shouldReconnect()) {
            this.attemptConnection();
        }
        if (!this.connectionState.isConnected()) {
            return false;
        }
        boolean success = this.attemptTransmit(syslogMessage);
        if (!success) {
            this.disconnect();
            this.attemptConnection();
            success = this.attemptTransmit(syslogMessage);
            if (!success) {
                this.connectionState.notifyError();
                this.disconnect();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptTransmit(byte[] syslogMessage) {
        long start = System.nanoTime();
        try {
            OutputStream outputStream = this.clientSocket.getOutputStream();
            outputStream.write(syslogMessage);
            outputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            this.lastTransmitError = ex.getMessage();
            LoggingMetrics.incrementDistributedLogTransmitError();
            boolean bl = false;
            return bl;
        }
        finally {
            LoggingMetrics.distributedLogTransmitTime(Duration.ofNanos(System.nanoTime() - start));
        }
    }

    public void attemptConnection() {
        try {
            SSLSocket clientSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket();
            clientSocket.setUseClientMode(true);
            clientSocket.setSoTimeout(this.timeoutMillis);
            this.sslParameters.configure((SSLConfigurable)new SSLConfigurableSocket(clientSocket));
            clientSocket.connect(new InetSocketAddress(this.syslogHost, this.port), this.timeoutMillis);
            clientSocket.startHandshake();
            clientSocket.setKeepAlive(true);
            this.clientSocket = clientSocket;
            this.onConnectionSuccesful();
        }
        catch (Exception ex) {
            this.disconnect();
            this.onConnectionError(ex);
        }
    }

    public void disconnect() {
        this.connectionState.notifyDisconnected();
        CloseUtil.closeQuietly((Socket)this.clientSocket);
        this.clientSocket = null;
    }

    private void onConnectionSuccesful() {
        this.connectionState.notifyConnected();
        LoggingMetrics.incrementDistributedLogConnectionEstablished();
        if (!this.connectionLoggedOnce) {
            this.connectionLoggedOnce = true;
            System.out.printf("TLS Syslog Appender connected to %s:%d\n", this.syslogHost, this.port);
        }
    }

    private void onConnectionError(Exception ex) {
        this.connectionState.notifyError();
        LoggingMetrics.incrementDistributedLogConnectionError();
        if (!this.connectionLoggedOnce) {
            this.connectionLoggedOnce = true;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(baos, true));
            System.err.printf("TLS Syslog Appender failed to connect to %s:%d: %s\n", this.syslogHost, this.port, baos.toString(StandardCharsets.UTF_8));
        }
    }

    public TLSSyslogConnection(String syslogHost, int port, SSLContext sslContext, SSLParametersConfiguration sslParameters, int timeoutMillis) {
        this.syslogHost = syslogHost;
        this.port = port;
        this.sslContext = sslContext;
        this.sslParameters = sslParameters;
        this.timeoutMillis = timeoutMillis;
    }

    public String getLastTransmitError() {
        return this.lastTransmitError;
    }
}

