/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.log.syslog.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

class SyslogMillisecondsPrefix {
    private final DateTimeFormatter dateTimeFormatterDoubleDigitDay = DateTimeFormatter.ofPattern("MMM dd HH:mm:ss.SSS", Locale.US);
    private final DateTimeFormatter dateTimeFormatterSingleDigitDay = DateTimeFormatter.ofPattern("MMM  d HH:mm:ss.SSS", Locale.US);
    private String localHostName;

    SyslogMillisecondsPrefix() {
    }

    void start() {
        this.localHostName = this.getLocalHostname();
    }

    String getPrefix(ILoggingEvent event) {
        int pri = 8 + LevelToSyslogSeverity.convert((ILoggingEvent)event);
        return "<" + pri + ">" + this.computeTimeStampString(event.getTimeStamp()) + " " + this.localHostName + " ";
    }

    private String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            return "UNKNOWN_LOCALHOST";
        }
    }

    private String computeTimeStampString(long millis) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
        return localDateTime.getDayOfMonth() < 10 ? this.dateTimeFormatterSingleDigitDay.format(localDateTime) : this.dateTimeFormatterDoubleDigitDay.format(localDateTime);
    }
}

