/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.rest.tracing;

import ch.admin.bag.covidcertificate.rest.tracing.RestRequestListener;
import ch.admin.bag.covidcertificate.rest.tracing.RestRequestTrace;
import ch.admin.bag.covidcertificate.rest.tracing.RestResponseListener;
import ch.admin.bag.covidcertificate.rest.tracing.RestResponseTrace;
import ch.admin.bag.covidcertificate.rest.tracing.TracerConfiguration;
import java.net.InetSocketAddress;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RestRequestTracer {
    private static final Logger log = LoggerFactory.getLogger(RestRequestTracer.class);
    private final TracerConfiguration tracerConfiguration;
    private final List<RestRequestListener> restRequestListeners;
    private final List<RestResponseListener> restResponseListeners;

    private void onRequest(@NonNull String requestUri, @NonNull String method) {
        if (requestUri == null) {
            throw new NullPointerException("requestUri is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (this.restRequestListeners.isEmpty() || this.restRequestListeners.stream().noneMatch(RestRequestListener::isRequestListenerActive)) {
            return;
        }
        RestRequestTrace restRequestTrace = RestRequestTrace.builder().method(method).requestUri(requestUri).build();
        for (RestRequestListener listener : this.restRequestListeners) {
            try {
                listener.onRequest(restRequestTrace);
            }
            catch (Exception ex) {
                log.warn("Exception in request listener", (Throwable)ex);
            }
        }
    }

    private void onResponse(String method, @NonNull String requestUri, String requestUriPattern, String user, ZonedDateTime incomingTime, Integer statusCode, InetSocketAddress remoteAddr, Map<String, List<String>> requestHeaders, Map<String, List<String>> responseHeaders, @NonNull Map<String, Object> attributes) {
        if (requestUri == null) {
            throw new NullPointerException("requestUri is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (this.restResponseListeners.isEmpty() || this.restResponseListeners.stream().noneMatch(RestResponseListener::isResponseListenerActive)) {
            return;
        }
        String callingApplicationName = Optional.ofNullable(requestHeaders.get("JEAP-APPLICATION-NAME")).map(Collection::stream).flatMap(Stream::findFirst).orElse(null);
        for (RestResponseListener listener : this.restResponseListeners) {
            try {
                RestResponseTrace restResponseTrace = RestResponseTrace.builder().method(method).requestUri(requestUri).requestUriPattern(requestUriPattern).statusCode(statusCode).caller(callingApplicationName).user(user).elapsedMs(ChronoUnit.MILLIS.between(incomingTime, ZonedDateTime.now())).remoteAddr(remoteAddr == null ? null : remoteAddr.toString()).requestHeaders(this.filterHeader(requestHeaders)).responseHeaders(this.filterHeader(responseHeaders)).attributes(this.filterAttributes(attributes)).build();
                listener.onResponse(restResponseTrace);
            }
            catch (Exception ex) {
                log.warn("Exception in request listener", (Throwable)ex);
            }
        }
    }

    private Map<String, List<String>> filterHeader(Map<String, List<String>> headers) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (this.tracerConfiguration.headerBlacklisted(entry.getKey())) continue;
            result.put(entry.getKey(), this.maskHeaderIfNeeded(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private List<String> maskHeaderIfNeeded(String headerName, List<String> headerValues) {
        if (this.tracerConfiguration.headersToBeMasked(headerName)) {
            return headerValues.stream().map(v -> "***").collect(Collectors.toList());
        }
        return headerValues;
    }

    private Map<String, String> filterAttributes(Map<String, Object> attributes) {
        return attributes.keySet().stream().filter(this.tracerConfiguration::attributeWhitelisted).collect(Collectors.toMap(Function.identity(), k -> attributes.get(k).toString()));
    }

    public OnRequestBuilder onRequestBuilder() {
        return new OnRequestBuilder();
    }

    public OnResponseBuilder onResponseBuilder() {
        return new OnResponseBuilder();
    }

    public RestRequestTracer(TracerConfiguration tracerConfiguration, List<RestRequestListener> restRequestListeners, List<RestResponseListener> restResponseListeners) {
        this.tracerConfiguration = tracerConfiguration;
        this.restRequestListeners = restRequestListeners;
        this.restResponseListeners = restResponseListeners;
    }

    public class OnResponseBuilder {
        private String method;
        private String requestUri;
        private String requestUriPattern;
        private String user;
        private ZonedDateTime incomingTime;
        private Integer statusCode;
        private InetSocketAddress remoteAddr;
        private Map<String, List<String>> requestHeaders;
        private Map<String, List<String>> responseHeaders;
        private Map<String, Object> attributes;

        OnResponseBuilder() {
        }

        public OnResponseBuilder method(String method) {
            this.method = method;
            return this;
        }

        public OnResponseBuilder requestUri(@NonNull String requestUri) {
            if (requestUri == null) {
                throw new NullPointerException("requestUri is marked non-null but is null");
            }
            this.requestUri = requestUri;
            return this;
        }

        public OnResponseBuilder requestUriPattern(String requestUriPattern) {
            this.requestUriPattern = requestUriPattern;
            return this;
        }

        public OnResponseBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OnResponseBuilder incomingTime(ZonedDateTime incomingTime) {
            this.incomingTime = incomingTime;
            return this;
        }

        public OnResponseBuilder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public OnResponseBuilder remoteAddr(InetSocketAddress remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public OnResponseBuilder requestHeaders(Map<String, List<String>> requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        public OnResponseBuilder responseHeaders(Map<String, List<String>> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public OnResponseBuilder attributes(@NonNull Map<String, Object> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            this.attributes = attributes;
            return this;
        }

        public void emit() {
            RestRequestTracer.this.onResponse(this.method, this.requestUri, this.requestUriPattern, this.user, this.incomingTime, this.statusCode, this.remoteAddr, this.requestHeaders, this.responseHeaders, this.attributes);
        }

        public String toString() {
            return "RestRequestTracer.OnResponseBuilder(method=" + this.method + ", requestUri=" + this.requestUri + ", requestUriPattern=" + this.requestUriPattern + ", user=" + this.user + ", incomingTime=" + this.incomingTime + ", statusCode=" + this.statusCode + ", remoteAddr=" + this.remoteAddr + ", requestHeaders=" + this.requestHeaders + ", responseHeaders=" + this.responseHeaders + ", attributes=" + this.attributes + ")";
        }
    }

    public class OnRequestBuilder {
        private String requestUri;
        private String method;

        OnRequestBuilder() {
        }

        public OnRequestBuilder requestUri(@NonNull String requestUri) {
            if (requestUri == null) {
                throw new NullPointerException("requestUri is marked non-null but is null");
            }
            this.requestUri = requestUri;
            return this;
        }

        public OnRequestBuilder method(@NonNull String method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            return this;
        }

        public void emit() {
            RestRequestTracer.this.onRequest(this.requestUri, this.method);
        }

        public String toString() {
            return "RestRequestTracer.OnRequestBuilder(requestUri=" + this.requestUri + ", method=" + this.method + ")";
        }
    }
}

