/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.rest.tracing;

import java.util.List;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:tracer.properties"})
@ConfigurationProperties(value="jeap.rest.tracing")
@ComponentScan
@ConditionalOnWebApplication
public class TracerConfiguration {
    private List<String> headerBlacklist;
    private List<String> headerMasked;
    private List<String> attributesWhitelist;
    private String applicationName;
    private Pattern uriFilterPattern;
    private boolean fullResponseDetailsInMessage;

    public boolean headerBlacklisted(String headerName) {
        String headerNameUpperCase = headerName.toUpperCase();
        return this.headerBlacklist.stream().map(String::toUpperCase).anyMatch(headerNameUpperCase::startsWith);
    }

    public boolean headersToBeMasked(String headerName) {
        String headerNameUpperCase = headerName.toUpperCase();
        return this.headerMasked.stream().map(String::toUpperCase).anyMatch(headerNameUpperCase::startsWith);
    }

    public boolean attributeWhitelisted(String attributeName) {
        String attributeNameUpperCase = attributeName.toUpperCase();
        return this.attributesWhitelist.stream().map(String::toUpperCase).anyMatch(attributeNameUpperCase::startsWith);
    }

    private static List<String> $default$headerBlacklist() {
        return List.of();
    }

    private static List<String> $default$headerMasked() {
        return List.of();
    }

    private static List<String> $default$attributesWhitelist() {
        return List.of();
    }

    public static TracerConfigurationBuilder builder() {
        return new TracerConfigurationBuilder();
    }

    public List<String> getHeaderBlacklist() {
        return this.headerBlacklist;
    }

    public List<String> getHeaderMasked() {
        return this.headerMasked;
    }

    public List<String> getAttributesWhitelist() {
        return this.attributesWhitelist;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Pattern getUriFilterPattern() {
        return this.uriFilterPattern;
    }

    public boolean isFullResponseDetailsInMessage() {
        return this.fullResponseDetailsInMessage;
    }

    public void setHeaderBlacklist(List<String> headerBlacklist) {
        this.headerBlacklist = headerBlacklist;
    }

    public void setHeaderMasked(List<String> headerMasked) {
        this.headerMasked = headerMasked;
    }

    public void setAttributesWhitelist(List<String> attributesWhitelist) {
        this.attributesWhitelist = attributesWhitelist;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setUriFilterPattern(Pattern uriFilterPattern) {
        this.uriFilterPattern = uriFilterPattern;
    }

    public void setFullResponseDetailsInMessage(boolean fullResponseDetailsInMessage) {
        this.fullResponseDetailsInMessage = fullResponseDetailsInMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TracerConfiguration)) {
            return false;
        }
        TracerConfiguration other = (TracerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFullResponseDetailsInMessage() != other.isFullResponseDetailsInMessage()) {
            return false;
        }
        List<String> this$headerBlacklist = this.getHeaderBlacklist();
        List<String> other$headerBlacklist = other.getHeaderBlacklist();
        if (this$headerBlacklist == null ? other$headerBlacklist != null : !((Object)this$headerBlacklist).equals(other$headerBlacklist)) {
            return false;
        }
        List<String> this$headerMasked = this.getHeaderMasked();
        List<String> other$headerMasked = other.getHeaderMasked();
        if (this$headerMasked == null ? other$headerMasked != null : !((Object)this$headerMasked).equals(other$headerMasked)) {
            return false;
        }
        List<String> this$attributesWhitelist = this.getAttributesWhitelist();
        List<String> other$attributesWhitelist = other.getAttributesWhitelist();
        if (this$attributesWhitelist == null ? other$attributesWhitelist != null : !((Object)this$attributesWhitelist).equals(other$attributesWhitelist)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        Pattern this$uriFilterPattern = this.getUriFilterPattern();
        Pattern other$uriFilterPattern = other.getUriFilterPattern();
        return !(this$uriFilterPattern == null ? other$uriFilterPattern != null : !this$uriFilterPattern.equals(other$uriFilterPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TracerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFullResponseDetailsInMessage() ? 79 : 97);
        List<String> $headerBlacklist = this.getHeaderBlacklist();
        result = result * 59 + ($headerBlacklist == null ? 43 : ((Object)$headerBlacklist).hashCode());
        List<String> $headerMasked = this.getHeaderMasked();
        result = result * 59 + ($headerMasked == null ? 43 : ((Object)$headerMasked).hashCode());
        List<String> $attributesWhitelist = this.getAttributesWhitelist();
        result = result * 59 + ($attributesWhitelist == null ? 43 : ((Object)$attributesWhitelist).hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        Pattern $uriFilterPattern = this.getUriFilterPattern();
        result = result * 59 + ($uriFilterPattern == null ? 43 : $uriFilterPattern.hashCode());
        return result;
    }

    public String toString() {
        return "TracerConfiguration(headerBlacklist=" + this.getHeaderBlacklist() + ", headerMasked=" + this.getHeaderMasked() + ", attributesWhitelist=" + this.getAttributesWhitelist() + ", applicationName=" + this.getApplicationName() + ", uriFilterPattern=" + this.getUriFilterPattern() + ", fullResponseDetailsInMessage=" + this.isFullResponseDetailsInMessage() + ")";
    }

    public TracerConfiguration() {
        this.headerBlacklist = TracerConfiguration.$default$headerBlacklist();
        this.headerMasked = TracerConfiguration.$default$headerMasked();
        this.attributesWhitelist = TracerConfiguration.$default$attributesWhitelist();
    }

    private TracerConfiguration(List<String> headerBlacklist, List<String> headerMasked, List<String> attributesWhitelist, String applicationName, Pattern uriFilterPattern, boolean fullResponseDetailsInMessage) {
        this.headerBlacklist = headerBlacklist;
        this.headerMasked = headerMasked;
        this.attributesWhitelist = attributesWhitelist;
        this.applicationName = applicationName;
        this.uriFilterPattern = uriFilterPattern;
        this.fullResponseDetailsInMessage = fullResponseDetailsInMessage;
    }

    public static class TracerConfigurationBuilder {
        private boolean headerBlacklist$set;
        private List<String> headerBlacklist$value;
        private boolean headerMasked$set;
        private List<String> headerMasked$value;
        private boolean attributesWhitelist$set;
        private List<String> attributesWhitelist$value;
        private String applicationName;
        private Pattern uriFilterPattern;
        private boolean fullResponseDetailsInMessage;

        TracerConfigurationBuilder() {
        }

        public TracerConfigurationBuilder headerBlacklist(List<String> headerBlacklist) {
            this.headerBlacklist$value = headerBlacklist;
            this.headerBlacklist$set = true;
            return this;
        }

        public TracerConfigurationBuilder headerMasked(List<String> headerMasked) {
            this.headerMasked$value = headerMasked;
            this.headerMasked$set = true;
            return this;
        }

        public TracerConfigurationBuilder attributesWhitelist(List<String> attributesWhitelist) {
            this.attributesWhitelist$value = attributesWhitelist;
            this.attributesWhitelist$set = true;
            return this;
        }

        public TracerConfigurationBuilder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public TracerConfigurationBuilder uriFilterPattern(Pattern uriFilterPattern) {
            this.uriFilterPattern = uriFilterPattern;
            return this;
        }

        public TracerConfigurationBuilder fullResponseDetailsInMessage(boolean fullResponseDetailsInMessage) {
            this.fullResponseDetailsInMessage = fullResponseDetailsInMessage;
            return this;
        }

        public TracerConfiguration build() {
            List<String> headerBlacklist$value = this.headerBlacklist$value;
            if (!this.headerBlacklist$set) {
                headerBlacklist$value = TracerConfiguration.$default$headerBlacklist();
            }
            List<String> headerMasked$value = this.headerMasked$value;
            if (!this.headerMasked$set) {
                headerMasked$value = TracerConfiguration.$default$headerMasked();
            }
            List<String> attributesWhitelist$value = this.attributesWhitelist$value;
            if (!this.attributesWhitelist$set) {
                attributesWhitelist$value = TracerConfiguration.$default$attributesWhitelist();
            }
            return new TracerConfiguration(headerBlacklist$value, headerMasked$value, attributesWhitelist$value, this.applicationName, this.uriFilterPattern, this.fullResponseDetailsInMessage);
        }

        public String toString() {
            return "TracerConfiguration.TracerConfigurationBuilder(headerBlacklist$value=" + this.headerBlacklist$value + ", headerMasked$value=" + this.headerMasked$value + ", attributesWhitelist$value=" + this.attributesWhitelist$value + ", applicationName=" + this.applicationName + ", uriFilterPattern=" + this.uriFilterPattern + ", fullResponseDetailsInMessage=" + this.fullResponseDetailsInMessage + ")";
        }
    }
}

