/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.log.metrics;

import ch.admin.bag.covidcertificate.log.metrics.LoggingMetricsProvider;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;

class MicrometerLoggingMetricsProvider
implements LoggingMetricsProvider {
    private static final String ASYNC_BUFFER_FULL_METRIC = "logging_async_buffer_full_fallback";
    private static final String DIST_LOG_CONNECTION_ERROR = "logging_distlog_connection_error";
    private static final String DIST_LOG_CONNECTION_ESTABLISHED = "logging_distlog_connection_established";
    private static final String DIST_LOG_TRANSMIT_ERROR = "logging_distlog_transmit_error";
    private static final String DIST_LOG_TRANSMIT_TIME = "logging_distlog_transmit_time";
    private static final String DIST_LOG_FALLBACK = "logging_distlog_fallback";
    private final Counter asyncBufferFullFallback;
    private final Counter distLogConnectionError;
    private final Counter distLogConnectionEstablished;
    private final Counter distLogTransmitError;
    private final Counter distLogFallback;
    private final Timer logTransmitTimer;

    MicrometerLoggingMetricsProvider(Object meterRegistryBean) {
        MeterRegistry meterRegistry = (MeterRegistry)meterRegistryBean;
        this.asyncBufferFullFallback = Counter.builder((String)ASYNC_BUFFER_FULL_METRIC).register(meterRegistry);
        this.distLogConnectionError = Counter.builder((String)DIST_LOG_CONNECTION_ERROR).register(meterRegistry);
        this.distLogConnectionEstablished = Counter.builder((String)DIST_LOG_CONNECTION_ESTABLISHED).register(meterRegistry);
        this.distLogTransmitError = Counter.builder((String)DIST_LOG_TRANSMIT_ERROR).register(meterRegistry);
        this.distLogFallback = Counter.builder((String)DIST_LOG_FALLBACK).register(meterRegistry);
        this.logTransmitTimer = Timer.builder((String)DIST_LOG_TRANSMIT_TIME).publishPercentiles(new double[]{0.5, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofHours(24L)).register(meterRegistry);
    }

    @Override
    public void incrementAsyncBufferFullFallback() {
        this.asyncBufferFullFallback.increment();
    }

    @Override
    public void incrementDistributedLogConnectionEstablished() {
        this.distLogConnectionEstablished.increment();
    }

    @Override
    public void incrementDistributedLogConnectionError() {
        this.distLogConnectionError.increment();
    }

    @Override
    public void incrementDistributedLogTransmitError() {
        this.distLogTransmitError.increment();
    }

    @Override
    public void incrementDistributedLogFallback() {
        this.distLogFallback.increment();
    }

    @Override
    public void distributedLogTransmitTime(Duration duration) {
        this.logTransmitTimer.record(duration);
    }
}

