/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.log.syslog.connection;

import java.time.Duration;
import java.util.function.Supplier;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.ExponentialBackOff;

class ConnectionState {
    private static final BackOff BACK_OFF;
    private boolean connected = false;
    private final Supplier<Long> clock;
    private long nextRetryMillis;
    private BackOffExecution backOffExecution;

    static ConnectionState disconnected() {
        return new ConnectionState(System::currentTimeMillis);
    }

    void notifyConnected() {
        this.connected = true;
        this.backOffExecution = null;
        this.nextRetryMillis = 0L;
    }

    void notifyDisconnected() {
        this.connected = false;
    }

    void notifyError() {
        if (this.backOffExecution == null) {
            this.backOffExecution = BACK_OFF.start();
        }
        this.nextRetryMillis = this.clock.get() + this.backOffExecution.nextBackOff();
    }

    boolean shouldReconnect() {
        if (this.connected) {
            return false;
        }
        return this.clock.get() > this.nextRetryMillis;
    }

    ConnectionState(Supplier<Long> clock) {
        this.clock = clock;
    }

    public boolean isConnected() {
        return this.connected;
    }

    static {
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff(2000L, 1.5);
        exponentialBackOff.setMaxInterval(Duration.ofMinutes(5L).toMillis());
        BACK_OFF = exponentialBackOff;
    }
}

