/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.log.async;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.LifeCycle;

public final class FallbackAppenderRef
extends AppenderAttachableImpl<ILoggingEvent>
implements LifeCycle {
    private boolean started;
    private boolean fallbackActive;

    public void start() {
        this.started = true;
        this.iteratorForAppenders().forEachRemaining(LifeCycle::start);
    }

    public void stop() {
        this.started = false;
        this.detachAndStopAllAppenders();
    }

    public void appendToFallbackAppender(ILoggingEvent loggingEvent, String reason) {
        if (!this.fallbackActive) {
            this.fallbackActive = true;
            this.logFallback(Level.WARN, "Activating fallback appender: " + reason);
        }
        this.appendLoopOnAppenders(loggingEvent);
    }

    public void notifyFallbackDeactivated() {
        if (this.fallbackActive) {
            this.fallbackActive = false;
            this.logFallback(Level.INFO, "Switching back from fallback to standard appender");
        }
    }

    private void logFallback(Level level, String message) {
        LoggingEvent loggingEvent = new LoggingEvent();
        loggingEvent.setLevel(level);
        loggingEvent.setLoggerName(FallbackAppenderRef.class.getName());
        loggingEvent.setMessage(message);
        loggingEvent.setTimeStamp(System.currentTimeMillis());
        loggingEvent.prepareForDeferredProcessing();
        this.appendLoopOnAppenders(loggingEvent);
    }

    public boolean isStarted() {
        return this.started;
    }
}

