/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.log.syslog;

import ch.admin.bag.covidcertificate.log.async.FallbackAppenderRef;
import ch.admin.bag.covidcertificate.log.metrics.LoggingMetrics;
import ch.admin.bag.covidcertificate.log.syslog.connection.TLSSyslogConnection;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.ssl.SSLComponent;
import ch.qos.logback.core.net.ssl.SSLConfiguration;
import ch.qos.logback.core.spi.ContextAware;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public class TLSSyslogAppender
extends AppenderBase<ILoggingEvent>
implements SSLComponent {
    private static final int DEFAULT_PORT = 6514;
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    private static final int MAX_MESSAGE_SIZE_LIMIT = 65000;
    private String syslogHost;
    private int port = 6514;
    private int timeoutMillis = 5000;
    private int maxMessageSize = 65000;
    private Encoder<ILoggingEvent> encoder;
    private FallbackAppenderRef fallback;
    private SSLConfiguration ssl = new SSLConfiguration();
    private TLSSyslogConnection syslogConnection;

    protected void append(ILoggingEvent eventObject) {
        byte[] syslogMessage = this.encoder.encode((Object)eventObject);
        if (!this.transmit(syslogMessage)) {
            LoggingMetrics.incrementDistributedLogFallback();
            this.fallback.appendToFallbackAppender(eventObject, "TLSSyslogAppender: " + this.syslogConnection.getLastTransmitError());
        } else {
            this.fallback.notifyFallbackDeactivated();
        }
    }

    protected boolean transmit(byte[] syslogMessage) {
        byte[] maxLengthSyslogMessage = syslogMessage;
        if (syslogMessage.length > this.maxMessageSize) {
            maxLengthSyslogMessage = Arrays.copyOfRange(syslogMessage, 0, this.maxMessageSize);
        }
        return this.syslogConnection.transmit(maxLengthSyslogMessage);
    }

    public void start() {
        if (this.syslogHost == null) {
            throw new IllegalArgumentException("syslogHost must be configured for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.fallback == null) {
            throw new IllegalArgumentException("fallback must be configured for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.encoder == null) {
            throw new IllegalArgumentException("an encoder must be configured for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        try {
            TLSSyslogAppender contextAware = this;
            this.syslogConnection = this.createSyslogConnection((ContextAware)contextAware);
            super.start();
            this.syslogConnection.attemptConnection();
        }
        catch (Exception e) {
            this.addError(String.format("Error starting " + ((Object)((Object)this)).getClass().getSimpleName() + " using syslog host %s:%d", this.syslogHost, this.port), e);
        }
    }

    public void stop() {
        super.stop();
        if (this.syslogConnection != null) {
            this.syslogConnection.disconnect();
            this.syslogConnection = null;
        }
    }

    protected TLSSyslogConnection createSyslogConnection(ContextAware contextAware) throws GeneralSecurityException {
        return TLSSyslogConnection.create(this.syslogHost, this.port, this.getSsl(), contextAware, this.timeoutMillis);
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public void setFallback(FallbackAppenderRef fallback) {
        this.fallback = fallback;
    }

    public void setSsl(SSLConfiguration ssl) {
        this.ssl = ssl;
    }

    public SSLConfiguration getSsl() {
        return this.ssl;
    }
}

