/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.extensions;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.VaccinationEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.products.Vaccine;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.AcceptanceCriterias;
import ch.admin.bag.covidcertificate.sdk.core.utils.DateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0007\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\t*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0002\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0011*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"doseNumber", "", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/VaccinationEntry;", "getCertificateIdentifier", "", "getIssuer", "getNumberOverTotalDose", "getVaccinationCountry", "showEnglishVersionForLabels", "", "hadPastInfection", "vaccine", "Lch/admin/bag/covidcertificate/sdk/core/models/products/Vaccine;", "isNotFullyProtected", "isTargetDiseaseCorrect", "totalDoses", "vaccineDate", "Ljava/time/LocalDateTime;", "validFromDate", "offsetInDays", "", "validUntilDate", "acceptanceCriterias", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/AcceptanceCriterias;", "CovidCertificate-SDK-Kotlin"})
public final class VaccinationEntryExtensionsKt {
    public static final int doseNumber(@NotNull VaccinationEntry $this$doseNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$doseNumber, (String)"$this$doseNumber");
        return $this$doseNumber.getDoseNumber();
    }

    public static final int totalDoses(@NotNull VaccinationEntry $this$totalDoses) {
        Intrinsics.checkNotNullParameter((Object)$this$totalDoses, (String)"$this$totalDoses");
        return $this$totalDoses.getTotalDoses();
    }

    public static final boolean hadPastInfection(@NotNull VaccinationEntry $this$hadPastInfection, @NotNull Vaccine vaccine) {
        Intrinsics.checkNotNullParameter((Object)$this$hadPastInfection, (String)"$this$hadPastInfection");
        Intrinsics.checkNotNullParameter((Object)vaccine, (String)"vaccine");
        return vaccine.getTotal_dosis_number() > VaccinationEntryExtensionsKt.totalDoses($this$hadPastInfection);
    }

    @NotNull
    public static final String getNumberOverTotalDose(@NotNull VaccinationEntry $this$getNumberOverTotalDose) {
        Intrinsics.checkNotNullParameter((Object)$this$getNumberOverTotalDose, (String)"$this$getNumberOverTotalDose");
        return "" + ' ' + VaccinationEntryExtensionsKt.doseNumber($this$getNumberOverTotalDose) + '/' + VaccinationEntryExtensionsKt.totalDoses($this$getNumberOverTotalDose);
    }

    public static final boolean isNotFullyProtected(@NotNull VaccinationEntry $this$isNotFullyProtected) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotFullyProtected, (String)"$this$isNotFullyProtected");
        return $this$isNotFullyProtected.getDoseNumber() < $this$isNotFullyProtected.getTotalDoses();
    }

    public static final boolean isTargetDiseaseCorrect(@NotNull VaccinationEntry $this$isTargetDiseaseCorrect) {
        Intrinsics.checkNotNullParameter((Object)$this$isTargetDiseaseCorrect, (String)"$this$isTargetDiseaseCorrect");
        return Intrinsics.areEqual((Object)$this$isTargetDiseaseCorrect.getDisease(), (Object)"840539006");
    }

    @Nullable
    public static final LocalDateTime validFromDate(@NotNull VaccinationEntry $this$validFromDate, long offsetInDays) {
        Intrinsics.checkNotNullParameter((Object)$this$validFromDate, (String)"$this$validFromDate");
        LocalDateTime localDateTime = VaccinationEntryExtensionsKt.vaccineDate($this$validFromDate);
        if (localDateTime == null) {
            return null;
        }
        LocalDateTime vaccineDate = localDateTime;
        return vaccineDate.plusDays(offsetInDays);
    }

    @Nullable
    public static final LocalDateTime validUntilDate(@NotNull VaccinationEntry $this$validUntilDate, @NotNull AcceptanceCriterias acceptanceCriterias) {
        Intrinsics.checkNotNullParameter((Object)$this$validUntilDate, (String)"$this$validUntilDate");
        Intrinsics.checkNotNullParameter((Object)acceptanceCriterias, (String)"acceptanceCriterias");
        LocalDateTime localDateTime = VaccinationEntryExtensionsKt.vaccineDate($this$validUntilDate);
        if (localDateTime == null) {
            return null;
        }
        LocalDateTime vaccinationImmunityEndDate = localDateTime;
        return vaccinationImmunityEndDate.plusDays(acceptanceCriterias.getVaccineImmunity());
    }

    @Nullable
    public static final LocalDateTime vaccineDate(@NotNull VaccinationEntry $this$vaccineDate) {
        Intrinsics.checkNotNullParameter((Object)$this$vaccineDate, (String)"$this$vaccineDate");
        LocalDate localDate = DateUtil.parseDate$default(DateUtil.INSTANCE, $this$vaccineDate.getVaccinationDate(), null, 2, null);
        return localDate != null ? localDate.atStartOfDay() : null;
    }

    @NotNull
    public static final String getVaccinationCountry(@NotNull VaccinationEntry $this$getVaccinationCountry, boolean showEnglishVersionForLabels) {
        Intrinsics.checkNotNullParameter((Object)$this$getVaccinationCountry, (String)"$this$getVaccinationCountry");
        try {
            Locale loc = new Locale("", $this$getVaccinationCountry.getCountry());
            String countryString = loc.getDisplayCountry();
            if (showEnglishVersionForLabels) {
                countryString = countryString + " / " + loc.getDisplayCountry(Locale.ENGLISH);
            }
            String string = countryString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"countryString");
            return string;
        }
        catch (Exception e) {
            String string = $this$getVaccinationCountry.getCountry();
            return string;
        }
    }

    @NotNull
    public static final String getIssuer(@NotNull VaccinationEntry $this$getIssuer) {
        Intrinsics.checkNotNullParameter((Object)$this$getIssuer, (String)"$this$getIssuer");
        return $this$getIssuer.getCertificateIssuer();
    }

    @NotNull
    public static final String getCertificateIdentifier(@NotNull VaccinationEntry $this$getCertificateIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getCertificateIdentifier, (String)"$this$getCertificateIdentifier");
        return $this$getCertificateIdentifier.getCertificateIdentifier();
    }
}

