/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules;

import ch.admin.bag.covidcertificate.sdk.core.extensions.RecoveryEntryExtensionsKt;
import ch.admin.bag.covidcertificate.sdk.core.extensions.TestEntryExtensionsKt;
import ch.admin.bag.covidcertificate.sdk.core.extensions.VaccinationEntryExtensionsKt;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.RecoveryEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.TestEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.VaccinationEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.state.CheckNationalRulesState;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicData;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicExternalInfo;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicPayload;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.Rule;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.RuleSet;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.RuleValueSets;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.NationalRulesError;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.ValidityRange;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/NationalRulesVerifier;", "", "()V", "getErrorStateForRule", "Lch/admin/bag/covidcertificate/sdk/core/models/state/CheckNationalRulesState;", "rule", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Rule;", "dccCert", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/DccCert;", "ruleValueSets", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RuleValueSets;", "getValidityRange", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/ValidityRange;", "verify", "ruleSet", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RuleSet;", "clock", "Ljava/time/Clock;", "CovidCertificate-SDK-Kotlin"})
public final class NationalRulesVerifier {
    @NotNull
    public final CheckNationalRulesState verify(@NotNull DccCert dccCert, @NotNull RuleSet ruleSet, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Intrinsics.checkNotNullParameter((Object)ruleSet, (String)"ruleSet");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        CertLogicPayload payload = new CertLogicPayload(dccCert.getPastInfections(), dccCert.getTests(), dccCert.getVaccinations());
        String validationClock = ZonedDateTime.now(clock).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String validationClockAtStartOfDay = LocalDate.now(clock).atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        RuleValueSets ruleValueSets = ruleSet.getValueSets();
        String string = validationClock;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"validationClock");
        String string2 = validationClockAtStartOfDay;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"validationClockAtStartOfDay");
        CertLogicExternalInfo externalInfo = new CertLogicExternalInfo(ruleValueSets, string, string2);
        CertLogicData ruleSetData = new CertLogicData(payload, externalInfo);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        for (Rule rule : ruleSet.getRules()) {
            JsonNode ruleLogic;
            JsonNode jsonNode = ruleLogic = jacksonMapper.readTree(rule.getLogic());
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"ruleLogic");
            JsonNode jsonNode2 = data;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"data");
            boolean isSuccessful = CertlogicKt.isTruthy(CertlogicKt.evaluate(jsonNode, jsonNode2));
            if (isSuccessful) continue;
            return this.getErrorStateForRule(rule, dccCert, ruleSetData.getExternal().getValueSets());
        }
        ValidityRange validityRange = this.getValidityRange(dccCert, ruleSetData.getExternal().getValueSets());
        return validityRange != null ? (CheckNationalRulesState)new CheckNationalRulesState.SUCCESS(validityRange) : (CheckNationalRulesState)new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, null, 2, null);
    }

    public static /* synthetic */ CheckNationalRulesState verify$default(NationalRulesVerifier nationalRulesVerifier, DccCert dccCert, RuleSet ruleSet, Clock clock, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.verify(dccCert, ruleSet, clock);
    }

    private final CheckNationalRulesState getErrorStateForRule(Rule rule, DccCert dccCert, RuleValueSets ruleValueSets) {
        CheckNationalRulesState checkNationalRulesState;
        switch (rule.getId()) {
            case "GR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_DISEASE_TARGET, rule.getId());
                break;
            }
            case "VR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_VACCINE_ENTRIES, rule.getId());
                break;
            }
            case "VR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NOT_FULLY_PROTECTED, rule.getId());
                break;
            }
            case "VR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getId());
                break;
            }
            case "VR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getId());
                break;
            }
            case "VR-CH-0004": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange2 = validityRange;
                    boolean bl = false;
                    boolean bl2 = false;
                    ValidityRange it = validityRange2;
                    boolean bl3 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            case "VR-CH-0005": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange3 = validityRange;
                    boolean bl = false;
                    boolean bl4 = false;
                    ValidityRange it = validityRange3;
                    boolean bl5 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            case "VR-CH-0006": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange4 = validityRange;
                    boolean bl = false;
                    boolean bl6 = false;
                    ValidityRange it = validityRange4;
                    boolean bl7 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            case "TR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_TEST_ENTRIES, rule.getId());
                break;
            }
            case "TR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.POSITIVE_RESULT, rule.getId());
                break;
            }
            case "TR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_TEST_TYPE, rule.getId());
                break;
            }
            case "TR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getId());
                break;
            }
            case "TR-CH-0004": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getId());
                break;
            }
            case "TR-CH-0005": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange5 = validityRange;
                    boolean bl = false;
                    boolean bl8 = false;
                    ValidityRange it = validityRange5;
                    boolean bl9 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            case "TR-CH-0006": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange6 = validityRange;
                    boolean bl = false;
                    boolean bl10 = false;
                    ValidityRange it = validityRange6;
                    boolean bl11 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            case "TR-CH-0007": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange7 = validityRange;
                    boolean bl = false;
                    boolean bl12 = false;
                    ValidityRange it = validityRange7;
                    boolean bl13 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            case "RR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_RECOVERY_ENTRIES, rule.getId());
                break;
            }
            case "RR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getId());
                break;
            }
            case "RR-CH-0002": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange8 = validityRange;
                    boolean bl = false;
                    boolean bl14 = false;
                    ValidityRange it = validityRange8;
                    boolean bl15 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            case "RR-CH-0003": {
                ValidityRange validityRange = this.getValidityRange(dccCert, ruleValueSets);
                if (validityRange != null) {
                    ValidityRange validityRange9 = validityRange;
                    boolean bl = false;
                    boolean bl16 = false;
                    ValidityRange it = validityRange9;
                    boolean bl17 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getId());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getId());
                break;
            }
            default: {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.UNKNOWN_RULE_FAILED, rule.getId());
            }
        }
        return checkNationalRulesState;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ValidityRange getValidityRange(DccCert dccCert, RuleValueSets ruleValueSets) {
        Object test;
        ValidityRange validityRange;
        Object vaccination;
        Collection collection = dccCert.getVaccinations();
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            Integer offset;
            Integer n;
            vaccination = (VaccinationEntry)CollectionsKt.first(dccCert.getVaccinations());
            List<String> list = ruleValueSets.getOneDoseVaccinesWithOffset();
            if (list != null && list.contains(((VaccinationEntry)vaccination).getMedicinialProduct())) {
                n = ruleValueSets.getAcceptanceCriteria().getSingleVaccineValidityOffset();
            } else {
                List<String> list2 = ruleValueSets.getTwoDoseVaccines();
                if (list2 == null) return null;
                if (!list2.contains(((VaccinationEntry)vaccination).getMedicinialProduct())) return null;
                n = 0;
            }
            Integer n2 = offset = n;
            if (n2 == null) return null;
            Integer n3 = n2;
            boolean bl3 = false;
            boolean bl4 = false;
            int it = ((Number)n3).intValue();
            boolean bl5 = false;
            validityRange = new ValidityRange(VaccinationEntryExtensionsKt.validFromDate((VaccinationEntry)vaccination, it), VaccinationEntryExtensionsKt.validUntilDate((VaccinationEntry)vaccination, ruleValueSets.getAcceptanceCriteria()));
            return validityRange;
        }
        vaccination = dccCert.getTests();
        bl = false;
        bl2 = false;
        if (!(vaccination == null || vaccination.isEmpty())) {
            test = (TestEntry)CollectionsKt.first(dccCert.getTests());
            validityRange = new ValidityRange(TestEntryExtensionsKt.validFromDate((TestEntry)test), TestEntryExtensionsKt.validUntilDate((TestEntry)test, ruleValueSets.getAcceptanceCriteria()));
            return validityRange;
        }
        test = dccCert.getPastInfections();
        bl = false;
        bl2 = false;
        if (test == null) return null;
        if (test.isEmpty()) {
            return null;
        }
        boolean bl6 = false;
        if (bl6) return null;
        RecoveryEntry recovery = (RecoveryEntry)CollectionsKt.first(dccCert.getPastInfections());
        validityRange = new ValidityRange(RecoveryEntryExtensionsKt.validFromDate(recovery, ruleValueSets.getAcceptanceCriteria()), RecoveryEntryExtensionsKt.validUntilDate(recovery, ruleValueSets.getAcceptanceCriteria()));
        return validityRange;
    }
}

