/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.extensions;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.RecoveryEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.AcceptanceCriterias;
import ch.admin.bag.covidcertificate.sdk.core.utils.DateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0002\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"firstPositiveResult", "Ljava/time/LocalDateTime;", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/RecoveryEntry;", "getCertificateIdentifier", "", "getIssuer", "getRecoveryCountry", "showEnglishVersionForLabels", "", "isTargetDiseaseCorrect", "validFromDate", "acceptanceCriterias", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/AcceptanceCriterias;", "validUntilDate", "CovidCertificate-SDK-Kotlin"})
public final class RecoveryEntryExtensionsKt {
    public static final boolean isTargetDiseaseCorrect(@NotNull RecoveryEntry $this$isTargetDiseaseCorrect) {
        Intrinsics.checkNotNullParameter((Object)$this$isTargetDiseaseCorrect, (String)"$this$isTargetDiseaseCorrect");
        return Intrinsics.areEqual((Object)$this$isTargetDiseaseCorrect.getDisease(), (Object)"840539006");
    }

    @NotNull
    public static final String getRecoveryCountry(@NotNull RecoveryEntry $this$getRecoveryCountry, boolean showEnglishVersionForLabels) {
        Intrinsics.checkNotNullParameter((Object)$this$getRecoveryCountry, (String)"$this$getRecoveryCountry");
        try {
            Locale loc = new Locale("", $this$getRecoveryCountry.getCountryOfTest());
            String countryString = loc.getDisplayCountry();
            if (showEnglishVersionForLabels) {
                countryString = countryString + " / " + loc.getDisplayCountry(Locale.ENGLISH);
            }
            String string = countryString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"countryString");
            return string;
        }
        catch (Exception e) {
            String string = $this$getRecoveryCountry.getCountryOfTest();
            return string;
        }
    }

    @NotNull
    public static final String getIssuer(@NotNull RecoveryEntry $this$getIssuer) {
        Intrinsics.checkNotNullParameter((Object)$this$getIssuer, (String)"$this$getIssuer");
        return $this$getIssuer.getCertificateIssuer();
    }

    @NotNull
    public static final String getCertificateIdentifier(@NotNull RecoveryEntry $this$getCertificateIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getCertificateIdentifier, (String)"$this$getCertificateIdentifier");
        return $this$getCertificateIdentifier.getCertificateIdentifier();
    }

    @Nullable
    public static final LocalDateTime validFromDate(@NotNull RecoveryEntry $this$validFromDate, @NotNull AcceptanceCriterias acceptanceCriterias) {
        Intrinsics.checkNotNullParameter((Object)$this$validFromDate, (String)"$this$validFromDate");
        Intrinsics.checkNotNullParameter((Object)acceptanceCriterias, (String)"acceptanceCriterias");
        LocalDateTime localDateTime = RecoveryEntryExtensionsKt.firstPositiveResult($this$validFromDate);
        if (localDateTime == null) {
            return null;
        }
        LocalDateTime firstPositiveResultDate = localDateTime;
        return firstPositiveResultDate.plusDays(acceptanceCriterias.getRecoveryOffsetValidFrom());
    }

    @Nullable
    public static final LocalDateTime validUntilDate(@NotNull RecoveryEntry $this$validUntilDate, @NotNull AcceptanceCriterias acceptanceCriterias) {
        Intrinsics.checkNotNullParameter((Object)$this$validUntilDate, (String)"$this$validUntilDate");
        Intrinsics.checkNotNullParameter((Object)acceptanceCriterias, (String)"acceptanceCriterias");
        LocalDateTime localDateTime = RecoveryEntryExtensionsKt.firstPositiveResult($this$validUntilDate);
        if (localDateTime == null) {
            return null;
        }
        LocalDateTime firstPositiveResultDate = localDateTime;
        return firstPositiveResultDate.plusDays(acceptanceCriterias.getRecoveryOffsetValidUntil());
    }

    @Nullable
    public static final LocalDateTime firstPositiveResult(@NotNull RecoveryEntry $this$firstPositiveResult) {
        Intrinsics.checkNotNullParameter((Object)$this$firstPositiveResult, (String)"$this$firstPositiveResult");
        LocalDate localDate = DateUtil.parseDate$default(DateUtil.INSTANCE, $this$firstPositiveResult.getDateFirstPositiveTest(), null, 2, null);
        return localDate != null ? localDate.atStartOfDay() : null;
    }
}

