/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/utils/DateUtil;", "", "()V", "DEFAULT_DISPLAY_DATE_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getDEFAULT_DISPLAY_DATE_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "formatDate", "", "date", "Ljava/time/LocalDate;", "formatter", "parseDate", "input", "zoneId", "Ljava/time/ZoneId;", "parseDateTime", "Ljava/time/LocalDateTime;", "CovidCertificate-SDK-Kotlin"})
public final class DateUtil {
    @NotNull
    private static final DateTimeFormatter DEFAULT_DISPLAY_DATE_FORMATTER;
    @NotNull
    public static final DateUtil INSTANCE;

    @NotNull
    public final DateTimeFormatter getDEFAULT_DISPLAY_DATE_FORMATTER() {
        return DEFAULT_DISPLAY_DATE_FORMATTER;
    }

    @Nullable
    public final LocalDate parseDate(@NotNull String input, @NotNull ZoneId zoneId) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        try {
            localDate = OffsetDateTime.parse(input).atZoneSameInstant(zoneId).toLocalDate();
        }
        catch (DateTimeParseException e) {
            LocalDate localDate2;
            try {
                localDate2 = LocalDateTime.parse(input).atOffset(ZoneOffset.UTC).atZoneSameInstant(zoneId).toLocalDate();
            }
            catch (DateTimeParseException e2) {
                LocalDate localDate3;
                try {
                    localDate3 = LocalDate.parse(input);
                }
                catch (DateTimeParseException e3) {
                    localDate3 = null;
                }
                localDate2 = localDate3;
            }
            localDate = localDate2;
        }
        return localDate;
    }

    public static /* synthetic */ LocalDate parseDate$default(DateUtil dateUtil, String string, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateUtil.parseDate(string, zoneId);
    }

    @Nullable
    public final LocalDateTime parseDateTime(@NotNull String input, @NotNull ZoneId zoneId) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        try {
            localDateTime = OffsetDateTime.parse(input).atZoneSameInstant(zoneId).toLocalDateTime();
        }
        catch (DateTimeParseException e) {
            LocalDateTime localDateTime2;
            try {
                localDateTime2 = LocalDateTime.parse(input).atOffset(ZoneOffset.UTC).atZoneSameInstant(zoneId).toLocalDateTime();
            }
            catch (DateTimeParseException e2) {
                localDateTime2 = null;
            }
            localDateTime = localDateTime2;
        }
        return localDateTime;
    }

    public static /* synthetic */ LocalDateTime parseDateTime$default(DateUtil dateUtil, String string, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateUtil.parseDateTime(string, zoneId);
    }

    @NotNull
    public final String formatDate(@NotNull LocalDate date, @NotNull DateTimeFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        String string = formatter.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(date)");
        return string;
    }

    public static /* synthetic */ String formatDate$default(DateUtil dateUtil, LocalDate localDate, DateTimeFormatter dateTimeFormatter, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeFormatter = DEFAULT_DISPLAY_DATE_FORMATTER;
        }
        return dateUtil.formatDate(localDate, dateTimeFormatter);
    }

    private DateUtil() {
    }

    static {
        DateUtil dateUtil;
        INSTANCE = dateUtil = new DateUtil();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(\"dd.MM.yyyy\")");
        DEFAULT_DISPLAY_DATE_FORMATTER = dateTimeFormatter;
    }
}

