/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.utils;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nR\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/utils/CryptoUtil;", "", "()V", "ecParameterSpec", "Ljava/security/spec/ECParameterSpec;", "getEcParameterSpec", "()Ljava/security/spec/ECParameterSpec;", "ecPublicKeyFromCoordinate", "Ljava/security/PublicKey;", "x", "", "y", "rsaPublicKeyFromModulusExponent", "n", "e", "CovidCertificate-SDK-Kotlin"})
public final class CryptoUtil {
    private static ECParameterSpec ecParameterSpec;
    @NotNull
    public static final CryptoUtil INSTANCE;

    private final ECParameterSpec getEcParameterSpec() {
        if (ecParameterSpec == null) {
            ECParameterSpec eCParameterSpec;
            ECGenParameterSpec ecParameters = new ECGenParameterSpec("prime256v1");
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("ECDSA");
                algorithmParameters.init(ecParameters);
                eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
            }
            catch (Exception e) {
                KeyPair keyPair;
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("ECDSA");
                kpg.initialize(ecParameters, new SecureRandom());
                KeyPair keyPair2 = keyPair = kpg.generateKeyPair();
                Intrinsics.checkNotNullExpressionValue((Object)keyPair2, (String)"keyPair");
                PublicKey publicKey = keyPair2.getPublic();
                if (publicKey == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                }
                eCParameterSpec = ((ECPublicKey)publicKey).getParams();
            }
            ecParameterSpec = eCParameterSpec;
        }
        return ecParameterSpec;
    }

    @NotNull
    public final PublicKey ecPublicKeyFromCoordinate(@NotNull byte[] x, @NotNull byte[] y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        BigInteger x2 = new BigInteger(1, x);
        BigInteger y2 = new BigInteger(1, y);
        ECPoint ecPoint = new ECPoint(x2, y2);
        ECPublicKeySpec ecKeySpec = new ECPublicKeySpec(ecPoint, this.getEcParameterSpec());
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA");
        PublicKey publicKey = keyFactory.generatePublic(ecKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory.generatePublic(ecKeySpec)");
        return publicKey;
    }

    @NotNull
    public final PublicKey rsaPublicKeyFromModulusExponent(@NotNull byte[] n, @NotNull byte[] e) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, n), new BigInteger(1, e));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory.generatePublic(rsaPublicKeySpec)");
        return publicKey;
    }

    private CryptoUtil() {
    }

    static {
        CryptoUtil cryptoUtil;
        INSTANCE = cryptoUtil = new CryptoUtil();
    }
}

