/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.state.CheckNationalRulesState;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicData;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicExternalInfo;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicPayload;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.DisplayRule;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.Rule;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.RuleSet;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.DisplayValidityRangeCalculator;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.NationalRulesError;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.ValidityRange;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.InternalsKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJR\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/NationalRulesVerifier;", "", "()V", "validityRangeCalculator", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/DisplayValidityRangeCalculator;", "getCertlogicData", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/CertLogicData;", "dccCert", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/DccCert;", "valueSets", "", "", "", "clock", "Ljava/time/Clock;", "getErrorStateForRule", "Lch/admin/bag/covidcertificate/sdk/core/models/state/CheckNationalRulesState;", "rule", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Rule;", "displayRules", "", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/DisplayRule;", "certType", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "getValidityRange", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/ValidityRange;", "data", "Lcom/fasterxml/jackson/databind/JsonNode;", "verify", "ruleSet", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RuleSet;", "CovidCertificate-SDK-Kotlin"})
public final class NationalRulesVerifier {
    private final DisplayValidityRangeCalculator validityRangeCalculator = new DisplayValidityRangeCalculator();

    @NotNull
    public final CheckNationalRulesState verify(@NotNull DccCert dccCert, @NotNull RuleSet ruleSet, @NotNull CertType certType, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Intrinsics.checkNotNullParameter((Object)ruleSet, (String)"ruleSet");
        Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        CertLogicData ruleSetData = this.getCertlogicData(dccCert, ruleSet.getValueSets(), clock);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        for (Rule rule : ruleSet.getRules()) {
            JsonNode ruleLogic;
            JsonNode jsonNode = ruleLogic = jacksonMapper.readTree(rule.getLogic());
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"ruleLogic");
            JsonNode jsonNode2 = data;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"data");
            boolean isSuccessful = InternalsKt.isTruthy(CertlogicKt.evaluate(jsonNode, jsonNode2));
            if (isSuccessful) continue;
            return NationalRulesVerifier.getErrorStateForRule$default(this, rule, dccCert, ruleSet.getDisplayRules(), ruleSetData.getExternal().getValueSets(), certType, null, 32, null);
        }
        List<DisplayRule> list = ruleSet.getDisplayRules();
        JsonNode jsonNode = data;
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
        ValidityRange validityRange = this.getValidityRange(list, jsonNode, certType);
        return validityRange != null ? (CheckNationalRulesState)new CheckNationalRulesState.SUCCESS(validityRange) : (CheckNationalRulesState)new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, null, 2, null);
    }

    public static /* synthetic */ CheckNationalRulesState verify$default(NationalRulesVerifier nationalRulesVerifier, DccCert dccCert, RuleSet ruleSet, CertType certType, Clock clock, int n, Object object) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.verify(dccCert, ruleSet, certType, clock);
    }

    @NotNull
    public final CertLogicData getCertlogicData(@NotNull DccCert dccCert, @NotNull Map<String, String[]> valueSets, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Intrinsics.checkNotNullParameter(valueSets, (String)"valueSets");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        CertLogicPayload payload = new CertLogicPayload(dccCert.getPastInfections(), dccCert.getTests(), dccCert.getVaccinations());
        String validationClock = ZonedDateTime.now(clock).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String validationClockAtStartOfDay = LocalDate.now(clock).atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String string = validationClock;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"validationClock");
        String string2 = validationClockAtStartOfDay;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"validationClockAtStartOfDay");
        CertLogicExternalInfo externalInfo = new CertLogicExternalInfo(valueSets, string, string2);
        return new CertLogicData(payload, externalInfo);
    }

    public static /* synthetic */ CertLogicData getCertlogicData$default(NationalRulesVerifier nationalRulesVerifier, DccCert dccCert, Map map, Clock clock, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.getCertlogicData(dccCert, map, clock);
    }

    private final CheckNationalRulesState getErrorStateForRule(Rule rule, DccCert dccCert, List<DisplayRule> displayRules, Map<String, String[]> valueSets, CertType certType, Clock clock) {
        CheckNationalRulesState checkNationalRulesState;
        CertLogicData ruleSetData = this.getCertlogicData(dccCert, valueSets, clock);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        switch (rule.getIdentifier()) {
            case "GR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_DISEASE_TARGET, rule.getIdentifier());
                break;
            }
            case "VR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_VACCINE_ENTRIES, rule.getIdentifier());
                break;
            }
            case "VR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NOT_FULLY_PROTECTED, rule.getIdentifier());
                break;
            }
            case "VR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getIdentifier());
                break;
            }
            case "VR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "VR-CH-0004": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange2 = validityRange;
                    boolean bl = false;
                    boolean bl2 = false;
                    ValidityRange it = validityRange2;
                    boolean bl3 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "VR-CH-0005": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange3 = validityRange;
                    boolean bl = false;
                    boolean bl4 = false;
                    ValidityRange it = validityRange3;
                    boolean bl5 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "VR-CH-0006": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange4 = validityRange;
                    boolean bl = false;
                    boolean bl6 = false;
                    ValidityRange it = validityRange4;
                    boolean bl7 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "VR-CH-0007": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange5 = validityRange;
                    boolean bl = false;
                    boolean bl8 = false;
                    ValidityRange it = validityRange5;
                    boolean bl9 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "TR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_TEST_ENTRIES, rule.getIdentifier());
                break;
            }
            case "TR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.POSITIVE_RESULT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_TEST_TYPE, rule.getIdentifier());
                break;
            }
            case "TR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0004": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "TR-CH-0005": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange6 = validityRange;
                    boolean bl = false;
                    boolean bl10 = false;
                    ValidityRange it = validityRange6;
                    boolean bl11 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "TR-CH-0006": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange7 = validityRange;
                    boolean bl = false;
                    boolean bl12 = false;
                    ValidityRange it = validityRange7;
                    boolean bl13 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "TR-CH-0007": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange8 = validityRange;
                    boolean bl = false;
                    boolean bl14 = false;
                    ValidityRange it = validityRange8;
                    boolean bl15 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "TR-CH-0008": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NEGATIVE_RESULT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0009": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange9 = validityRange;
                    boolean bl = false;
                    boolean bl16 = false;
                    ValidityRange it = validityRange9;
                    boolean bl17 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "RR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_RECOVERY_ENTRIES, rule.getIdentifier());
                break;
            }
            case "RR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "RR-CH-0002": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange10 = validityRange;
                    boolean bl = false;
                    boolean bl18 = false;
                    ValidityRange it = validityRange10;
                    boolean bl19 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            case "RR-CH-0003": {
                JsonNode jsonNode = data;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, jsonNode, certType);
                if (validityRange != null) {
                    ValidityRange validityRange11 = validityRange;
                    boolean bl = false;
                    boolean bl20 = false;
                    ValidityRange it = validityRange11;
                    boolean bl21 = false;
                    checkNationalRulesState = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                break;
            }
            default: {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.UNKNOWN_RULE_FAILED, rule.getIdentifier());
            }
        }
        return checkNationalRulesState;
    }

    static /* synthetic */ CheckNationalRulesState getErrorStateForRule$default(NationalRulesVerifier nationalRulesVerifier, Rule rule, DccCert dccCert, List list, Map map, CertType certType, Clock clock, int n, Object object) {
        if ((n & 0x20) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.getErrorStateForRule(rule, dccCert, list, map, certType, clock);
    }

    private final ValidityRange getValidityRange(List<DisplayRule> displayRules, JsonNode data, CertType certType) {
        return this.validityRangeCalculator.getDisplayValidityRangeForSystemTimeZone(displayRules, data, certType);
    }
}

