/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.DisplayRule;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.ValidityRange;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.JsonDateTime;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/DisplayValidityRangeCalculator;", "", "()V", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDisplayValidityRangeForSystemTimeZone", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/ValidityRange;", "displayRules", "", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/DisplayRule;", "data", "Lcom/fasterxml/jackson/databind/JsonNode;", "certType", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/certlogic/JsonDateTime;", "getValidity", "displayRule", "", "CovidCertificate-SDK-Kotlin"})
public final class DisplayValidityRangeCalculator {
    private final ObjectMapper jacksonMapper;

    @Nullable
    public final ValidityRange getDisplayValidityRangeForSystemTimeZone(@NotNull List<DisplayRule> displayRules, @NotNull JsonNode data, @NotNull CertType certType) {
        Object object;
        Object v2;
        Object displayFromDate;
        block5: {
            Object object2;
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter(displayRules, (String)"displayRules");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
                Iterable iterable = displayRules;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object object3 : iterable2) {
                    DisplayRule it = (DisplayRule)object3;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"display-from-date")) continue;
                    v0 = object3;
                    break block4;
                }
                v0 = null;
            }
            if ((object2 = (DisplayRule)v0) == null || (object2 = ((DisplayRule)object2).getLogic()) == null) {
                return null;
            }
            displayFromDate = object2;
            Iterable iterable = displayRules;
            boolean bl = false;
            Iterable iterable3 = iterable;
            boolean bl4 = false;
            for (Object e : iterable3) {
                DisplayRule it = (DisplayRule)e;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"display-until-date")) continue;
                v2 = e;
                break block5;
            }
            v2 = null;
        }
        if ((object = (DisplayRule)v2) == null || (object = ((DisplayRule)object).getLogic()) == null) {
            return null;
        }
        Object displayUntilDate = object;
        LocalDateTime dateFromString = this.getValidity((String)displayFromDate, data, certType);
        LocalDateTime dateUntilString = this.getValidity((String)displayUntilDate, data, certType);
        return new ValidityRange(dateFromString, dateUntilString);
    }

    private final LocalDateTime getValidity(String displayRule, JsonNode data, CertType certType) {
        JsonNode displayLogic;
        JsonNode jsonNode = displayLogic = this.jacksonMapper.readTree(displayRule);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"displayLogic");
        JsonNode date = CertlogicKt.evaluate(jsonNode, data);
        if (date instanceof JsonDateTime) {
            return this.getLocalDateTime(certType, (JsonDateTime)date);
        }
        return null;
    }

    private final LocalDateTime getLocalDateTime(CertType certType, JsonDateTime data) {
        if (certType == CertType.TEST) {
            LocalDateTime localDateTime = data.temporalValue().atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"data.temporalValue().atZ\u2026ault()).toLocalDateTime()");
            return localDateTime;
        }
        LocalDateTime localDateTime = data.temporalValue().toLocalDate().atStartOfDay();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"data.temporalValue().toLocalDate().atStartOfDay()");
        return localDateTime;
    }

    /*
     * WARNING - void declaration
     */
    public DisplayValidityRangeCalculator() {
        void $this$apply;
        ObjectMapper objectMapper = new ObjectMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper objectMapper2 = objectMapper;
        DisplayValidityRangeCalculator displayValidityRangeCalculator = this;
        boolean bl3 = false;
        $this$apply.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        Unit unit = Unit.INSTANCE;
        displayValidityRangeCalculator.jacksonMapper = objectMapper;
    }
}

