/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.extensions;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.TestEntry;
import ch.admin.bag.covidcertificate.sdk.core.utils.DateUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002\u00a8\u0006\u0010"}, d2={"getCertificateIdentifier", "", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/TestEntry;", "getFormattedResultDate", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "getFormattedSampleDate", "getIssuer", "getTestCenter", "getTestCountry", "showEnglishVersionForLabels", "", "isNegative", "isTargetDiseaseCorrect", "validFromDate", "Ljava/time/LocalDateTime;", "CovidCertificate-SDK-Kotlin"})
public final class TestEntryExtensionsKt {
    public static final boolean isNegative(@NotNull TestEntry $this$isNegative) {
        Intrinsics.checkNotNullParameter((Object)$this$isNegative, (String)"$this$isNegative");
        return Intrinsics.areEqual((Object)$this$isNegative.getResult(), (Object)"260415000");
    }

    public static final boolean isTargetDiseaseCorrect(@NotNull TestEntry $this$isTargetDiseaseCorrect) {
        Intrinsics.checkNotNullParameter((Object)$this$isTargetDiseaseCorrect, (String)"$this$isTargetDiseaseCorrect");
        return Intrinsics.areEqual((Object)$this$isTargetDiseaseCorrect.getDisease(), (Object)"840539006");
    }

    @Nullable
    public static final String getFormattedSampleDate(@NotNull TestEntry $this$getFormattedSampleDate, @NotNull DateTimeFormatter dateTimeFormatter) {
        Intrinsics.checkNotNullParameter((Object)$this$getFormattedSampleDate, (String)"$this$getFormattedSampleDate");
        Intrinsics.checkNotNullParameter((Object)dateTimeFormatter, (String)"dateTimeFormatter");
        LocalDateTime localDateTime = DateUtil.parseDateTime$default(DateUtil.INSTANCE, $this$getFormattedSampleDate.getTimestampSample(), null, 2, null);
        return localDateTime != null ? localDateTime.format(dateTimeFormatter) : null;
    }

    @Nullable
    public static final String getFormattedResultDate(@NotNull TestEntry $this$getFormattedResultDate, @NotNull DateTimeFormatter dateTimeFormatter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getFormattedResultDate, (String)"$this$getFormattedResultDate");
        Intrinsics.checkNotNullParameter((Object)dateTimeFormatter, (String)"dateTimeFormatter");
        String string2 = $this$getFormattedResultDate.getTimestampResult();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            LocalDateTime localDateTime = DateUtil.parseDateTime$default(DateUtil.INSTANCE, it, null, 2, null);
            string = localDateTime != null ? localDateTime.format(dateTimeFormatter) : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String getTestCenter(@NotNull TestEntry $this$getTestCenter) {
        Intrinsics.checkNotNullParameter((Object)$this$getTestCenter, (String)"$this$getTestCenter");
        CharSequence charSequence = $this$getTestCenter.getTestCenter();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return $this$getTestCenter.getTestCenter();
        }
        return null;
    }

    @NotNull
    public static final String getTestCountry(@NotNull TestEntry $this$getTestCountry, boolean showEnglishVersionForLabels) {
        Intrinsics.checkNotNullParameter((Object)$this$getTestCountry, (String)"$this$getTestCountry");
        try {
            Locale loc = new Locale("", $this$getTestCountry.getCountry());
            String countryString = loc.getDisplayCountry();
            if (showEnglishVersionForLabels) {
                countryString = countryString + " / " + loc.getDisplayCountry(Locale.ENGLISH);
            }
            String string = countryString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"countryString");
            return string;
        }
        catch (Exception e) {
            String string = $this$getTestCountry.getCountry();
            return string;
        }
    }

    @NotNull
    public static final String getIssuer(@NotNull TestEntry $this$getIssuer) {
        Intrinsics.checkNotNullParameter((Object)$this$getIssuer, (String)"$this$getIssuer");
        return $this$getIssuer.getCertificateIssuer();
    }

    @NotNull
    public static final String getCertificateIdentifier(@NotNull TestEntry $this$getCertificateIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getCertificateIdentifier, (String)"$this$getCertificateIdentifier");
        return $this$getCertificateIdentifier.getCertificateIdentifier();
    }

    @Nullable
    public static final LocalDateTime validFromDate(@NotNull TestEntry $this$validFromDate) {
        Intrinsics.checkNotNullParameter((Object)$this$validFromDate, (String)"$this$validFromDate");
        return DateUtil.parseDateTime$default(DateUtil.INSTANCE, $this$validFromDate.getTimestampSample(), null, 2, null);
    }
}

