/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic;

import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.TimeUnit;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.ValidationError;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a8\u0006\u0010"}, d2={"validate", "", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/certlogic/ValidationError;", "expr", "Lcom/fasterxml/jackson/databind/JsonNode;", "validateExtractFromUVCI", "values", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "validateIf", "validateInfix", "operator", "", "validateNot", "validatePlusTime", "validateReduce", "validateVar", "CovidCertificate-SDK-Kotlin"})
public final class ValidatorKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<ValidationError> validateVar(@NotNull JsonNode expr, @NotNull JsonNode values) {
        List list;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (!(values instanceof TextNode)) {
            return CollectionsKt.listOf((Object)new ValidationError(expr, "not of the form { \"var\": \"<path>\" }"));
        }
        String path = values.asText();
        if (!Intrinsics.areEqual((Object)path, (Object)"")) {
            Regex regex = new Regex("^([^\\.]+?)(\\.[^\\.]+?)*$");
            String string = path;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            if (!regex.matches((CharSequence)string)) {
                list = CollectionsKt.listOf((Object)new ValidationError(expr, "data access path doesn't have a valid format: " + path));
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValidationError> validateIf(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)values)).subList(0, 3);
        Collection collection = values.size() == 3 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, "an \"if\"-operation must have exactly 3 values/operands, but it has " + values.size()));
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl = false;
            JsonNode jsonNode = it;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"it");
            Iterable list$iv$iv = ValidatorKt.validate(jsonNode);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValidationError> validateInfix(@NotNull JsonNode expr, @NotNull ArrayNode values, @NotNull String operator) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List list;
        int n;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        int nOperands = values.size();
        switch (operator) {
            case "and": {
                n = nOperands;
                break;
            }
            case "<=": 
            case "before": 
            case "after": 
            case "<": 
            case "not-after": 
            case "not-before": 
            case ">": 
            case ">=": {
                n = 3;
                break;
            }
            default: {
                n = 2;
            }
        }
        int maxOperands = n;
        switch (operator) {
            case "and": {
                if (nOperands < 2) {
                    list = CollectionsKt.listOf((Object)new ValidationError(expr, "an \"and\" operation must have at least 2 operands, but it has " + values.size()));
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            case "<=": 
            case "before": 
            case "after": 
            case "<": 
            case "not-after": 
            case "not-before": 
            case ">": 
            case ">=": {
                if (nOperands < 2 || nOperands > 3) {
                    list = CollectionsKt.listOf((Object)new ValidationError(expr, "an operation with operator \"" + operator + "\" must have 2 or 3 operands, but it has " + values.size()));
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                list = nOperands != 2 ? CollectionsKt.listOf((Object)new ValidationError(expr, "an operation with operator \"" + operator + "\" must have 2 operands, but it has " + values.size())) : CollectionsKt.emptyList();
            }
        }
        boolean bl = false;
        Iterable iterable = CollectionsKt.take((Iterable)((Iterable)values), (int)Math.min(maxOperands, nOperands));
        Collection collection = list;
        boolean $i$f$flatMap = false;
        void var7_10 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl2 = false;
            JsonNode jsonNode = it;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"it");
            Iterable list$iv$iv = ValidatorKt.validate(jsonNode);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    @NotNull
    public static final List<ValidationError> validateNot(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        List list;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (values.size() == 1) {
            JsonNode jsonNode = values.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"values[0]");
            list = ValidatorKt.validate(jsonNode);
        } else {
            list = CollectionsKt.listOf((Object)new ValidationError(expr, "a !-operation (logical not/negation) must have exactly 1 operand, but it has " + values.size()));
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<ValidationError> validatePlusTime(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        v0 = values.size() == 3 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, "a \"plusTime\"-operation must have exactly 3 values/operands, but it has " + values.size()));
        if (values.has(0)) {
            v1 = values.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"values[0]");
            v2 = ValidatorKt.validate(v1);
        } else {
            v2 = CollectionsKt.emptyList();
        }
        v3 = CollectionsKt.plus((Collection)v0, (Iterable)v2);
        if (!values.has(1)) ** GOTO lbl-1000
        v4 = values.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"values[1]");
        if (!v4.isInt()) {
            v5 = CollectionsKt.listOf((Object)new ValidationError(expr, "\"amount\" argument (#2) of \"plusTime\" must be an integer, but it is: " + values.get(1)));
        } else lbl-1000:
        // 2 sources

        {
            v5 = CollectionsKt.emptyList();
        }
        v6 = CollectionsKt.plus((Collection)v3, (Iterable)v5);
        if (values.has(2) && !TimeUnit.isTimeUnitName(values.get(2).asText())) {
            var2_2 = TimeUnit.values();
            var17_3 = new StringBuilder().append("\"unit\" argument (#3) of \"plusTime\" must be a string equal to one of ");
            var16_4 = expr;
            var13_5 = v6;
            $i$f$map = false;
            var4_7 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
            $i$f$mapTo = false;
            var7_10 = $this$mapTo$iv$iv;
            var8_11 = ((void)var7_10).length;
            for (var9_12 = 0; var9_12 < var8_11; ++var9_12) {
                var11_14 = item$iv$iv = var7_10[var9_12];
                var18_16 = destination$iv$iv;
                $i$a$-map-ValidatorKt$validatePlusTime$1 = false;
                var19_17 = it.name();
                var18_16.add(var19_17);
            }
            var18_16 = (List)destination$iv$iv;
            v6 = var13_5;
            var20_18 = var17_3.append(CollectionsKt.joinToString$default((Iterable)var18_16, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(", but it is: ").append(values.get(2)).toString();
            var21_19 = var16_4;
            v7 = CollectionsKt.listOf((Object)new ValidationError(var21_19, var20_18));
        } else {
            v7 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)v6, (Iterable)v7);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValidationError> validateReduce(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)values)).subList(0, 3);
        Collection collection = values.size() == 3 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, "an \"reduce\"-operation must have exactly 3 values/operands, but it has " + values.size()));
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl = false;
            JsonNode jsonNode = it;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"it");
            Iterable list$iv$iv = ValidatorKt.validate(jsonNode);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @NotNull
    public static final List<ValidationError> validateExtractFromUVCI(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        List<ValidationError> list;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Collection collection = values.size() == 2 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, "an \"extractFromUVCI\"-operation must have exactly 2 values/operands, but it has " + values.size()));
        if (values.has(0)) {
            JsonNode jsonNode = values.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"values[0]");
            list = ValidatorKt.validate(jsonNode);
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list), (Iterable)(values.has(1) && !(values.get(1) instanceof IntNode) ? CollectionsKt.listOf((Object)new ValidationError(expr, "\"index\" argument (#2) of \"extractFromUVCI\" must be an integer, but it is: " + values.get(1))) : CollectionsKt.emptyList()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<ValidationError> validate(@NotNull JsonNode expr) {
        List<ValidationError> list;
        void operator;
        Map.Entry entry;
        List list2;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Function1<String, List<? extends ValidationError>> $fun$withError$1 = new Function1<String, List<? extends ValidationError>>(expr){
            final /* synthetic */ JsonNode $expr;

            @NotNull
            public final List<ValidationError> invoke(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return CollectionsKt.listOf((Object)new ValidationError(this.$expr, message));
            }
            {
                this.$expr = jsonNode;
                super(1);
            }
        };
        JsonNode jsonNode = expr;
        if (jsonNode instanceof TextNode || jsonNode instanceof IntNode || jsonNode instanceof BooleanNode) {
            list2 = CollectionsKt.emptyList();
            return list2;
        }
        if (jsonNode instanceof NumericNode) {
            list2 = $fun$withError$1.invoke(expr + " is a non-integer number");
            return list2;
        }
        if (jsonNode instanceof NullNode) {
            list2 = $fun$withError$1.invoke("invalid CertLogic expression");
            return list2;
        }
        if (jsonNode instanceof ArrayNode) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)expr;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    list2 = (List)destination$iv$iv;
                    return list2;
                }
                Object element$iv$iv = iterator.next();
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl = false;
                JsonNode jsonNode2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"it");
                Iterable list$iv$iv = ValidatorKt.validate(jsonNode2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
        }
        if (!(jsonNode instanceof ObjectNode)) {
            list2 = $fun$withError$1.invoke("invalid CertLogic expression");
            return list2;
        }
        if (expr.size() != 1) {
            return $fun$withError$1.invoke("expression object must have exactly one key, but it has " + expr.size());
        }
        Map.Entry entry2 = entry = (Map.Entry)expr.fields().next();
        boolean bl = false;
        String $this$flatMap$iv = (String)entry2.getKey();
        entry2 = entry;
        bl = false;
        JsonNode args = (JsonNode)entry2.getValue();
        if (Intrinsics.areEqual((Object)operator, (Object)"var")) {
            JsonNode jsonNode3 = args;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode3, (String)"args");
            return ValidatorKt.validateVar(expr, jsonNode3);
        }
        if (!(args instanceof ArrayNode)) return $fun$withError$1.invoke("operation not of the form { \"<operator>\": [ <values...> ] }");
        if (args.size() <= 0) {
            return $fun$withError$1.invoke("operation not of the form { \"<operator>\": [ <values...> ] }");
        }
        void v3 = operator;
        if (v3 != null) {
            switch (v3) {
                case "if": {
                    list = ValidatorKt.validateIf(expr, (ArrayNode)args);
                    return list;
                }
                case "<=": 
                case "in": 
                case "before": 
                case "+": 
                case "not-after": 
                case "not-before": 
                case "and": 
                case "after": 
                case "<": 
                case "===": 
                case ">": 
                case ">=": {
                    list = ValidatorKt.validateInfix(expr, (ArrayNode)args, (String)operator);
                    return list;
                }
                case "!": {
                    list = ValidatorKt.validateNot(expr, (ArrayNode)args);
                    return list;
                }
                case "plusTime": {
                    list = ValidatorKt.validatePlusTime(expr, (ArrayNode)args);
                    return list;
                }
                case "reduce": {
                    list = ValidatorKt.validateReduce(expr, (ArrayNode)args);
                    return list;
                }
                case "extractFromUVCI": {
                    list = ValidatorKt.validateExtractFromUVCI(expr, (ArrayNode)args);
                    return list;
                }
            }
        }
        list = $fun$withError$1.invoke("unrecognised operator: \"" + (String)operator + '\"');
        return list;
    }
}

