/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.DisplayRule;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.ValidityRange;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.InternalsKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.JsonDateTime;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/DisplayValidityCalculator;", "", "()V", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "evalRule", "Lcom/fasterxml/jackson/databind/JsonNode;", "displayRules", "", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/DisplayRule;", "ruleName", "", "data", "getDateTime", "Ljava/time/LocalDateTime;", "resultFromDisplayRule", "certType", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "getDisplayValidityRangeForSystemTimeZone", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/ValidityRange;", "getLocalDateTime", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/certlogic/JsonDateTime;", "isOnlyValidInSwitzerland", "", "CovidCertificate-SDK-Kotlin"})
public final class DisplayValidityCalculator {
    private final ObjectMapper jacksonMapper;

    @Nullable
    public final ValidityRange getDisplayValidityRangeForSystemTimeZone(@NotNull List<DisplayRule> displayRules, @NotNull JsonNode data, @NotNull CertType certType) {
        Intrinsics.checkNotNullParameter(displayRules, (String)"displayRules");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
        JsonNode jsonNode = this.evalRule(displayRules, "display-from-date", data);
        if (jsonNode == null) {
            return null;
        }
        JsonNode resultFromDate = jsonNode;
        JsonNode jsonNode2 = this.evalRule(displayRules, "display-until-date", data);
        if (jsonNode2 == null) {
            return null;
        }
        JsonNode resultUntilDate = jsonNode2;
        LocalDateTime dateFromString = this.getDateTime(resultFromDate, data, certType);
        LocalDateTime dateUntilString = this.getDateTime(resultUntilDate, data, certType);
        return new ValidityRange(dateFromString, dateUntilString);
    }

    public final boolean isOnlyValidInSwitzerland(@NotNull List<DisplayRule> displayRules, @NotNull JsonNode data) {
        Intrinsics.checkNotNullParameter(displayRules, (String)"displayRules");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JsonNode jsonNode = this.evalRule(displayRules, "is-only-valid-in-ch", data);
        if (jsonNode == null) {
            return false;
        }
        JsonNode result = jsonNode;
        return InternalsKt.isTruthy(result);
    }

    private final LocalDateTime getDateTime(JsonNode resultFromDisplayRule, JsonNode data, CertType certType) {
        if (resultFromDisplayRule instanceof JsonDateTime) {
            return this.getLocalDateTime(certType, (JsonDateTime)resultFromDisplayRule);
        }
        return null;
    }

    private final LocalDateTime getLocalDateTime(CertType certType, JsonDateTime data) {
        if (certType == CertType.TEST) {
            LocalDateTime localDateTime = data.temporalValue().atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"data.temporalValue().atZ\u2026ault()).toLocalDateTime()");
            return localDateTime;
        }
        LocalDateTime localDateTime = data.temporalValue().toLocalDate().atStartOfDay();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"data.temporalValue().toLocalDate().atStartOfDay()");
        return localDateTime;
    }

    private final JsonNode evalRule(List<DisplayRule> displayRules, String ruleName, JsonNode data) {
        JsonNode displayLogic;
        Object object;
        Object v0;
        block2: {
            Iterable iterable = displayRules;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DisplayRule it = (DisplayRule)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)ruleName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (DisplayRule)v0) == null || (object = ((DisplayRule)object).getLogic()) == null) {
            return null;
        }
        Object displayRule = object;
        JsonNode jsonNode = displayLogic = this.jacksonMapper.readTree((String)displayRule);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"displayLogic");
        return CertlogicKt.evaluate(jsonNode, data);
    }

    /*
     * WARNING - void declaration
     */
    public DisplayValidityCalculator() {
        void $this$apply;
        ObjectMapper objectMapper = new ObjectMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper objectMapper2 = objectMapper;
        DisplayValidityCalculator displayValidityCalculator = this;
        boolean bl3 = false;
        $this$apply.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        Unit unit = Unit.INSTANCE;
        displayValidityCalculator.jacksonMapper = objectMapper;
    }
}

