/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.decoder.chain;

import ch.admin.bag.covidcertificate.sdk.core.data.moshi.TrimmedStringAdapter;
import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.CwtHeaderKeys;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertificateHolder;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.light.ChLightCert;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.Rfc3339DateJsonAdapter;
import com.upokecenter.cbor.CBORObject;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/decoder/chain/CborService;", "", "()V", "keyChLightCertV1", "Lcom/upokecenter/cbor/CBORObject;", "kotlin.jvm.PlatformType", "keyDccCertV1", "decode", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertificateHolder;", "input", "", "qrCodeData", "", "CovidCertificate-SDK-Kotlin"})
public final class CborService {
    private static final CBORObject keyDccCertV1;
    private static final CBORObject keyChLightCertV1;
    @NotNull
    public static final CborService INSTANCE;

    @Nullable
    public final CertificateHolder decode(@NotNull byte[] input, @NotNull String qrCodeData) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)qrCodeData, (String)"qrCodeData");
        Moshi moshi = new Moshi.Builder().add((Type)((Object)Date.class), (JsonAdapter)new Rfc3339DateJsonAdapter()).add((Type)((Object)String.class), (JsonAdapter)new TrimmedStringAdapter()).build();
        JsonAdapter dccCertAdapter = moshi.adapter(DccCert.class);
        JsonAdapter chLightCertAdapter = moshi.adapter(ChLightCert.class);
        try {
            boolean bl;
            Instant instant;
            Instant instant2;
            boolean bl2;
            CBORObject map = CBORObject.DecodeFromBytes((byte[])input);
            CBORObject cBORObject = map.get(CwtHeaderKeys.EXPIRATION.INSTANCE.asCBOR());
            if (cBORObject != null) {
                CBORObject cBORObject2 = cBORObject;
                boolean bl3 = false;
                bl2 = false;
                CBORObject it = cBORObject2;
                boolean bl4 = false;
                instant2 = Instant.ofEpochSecond(it.AsInt64());
            } else {
                instant2 = null;
            }
            Instant expirationTime = instant2;
            CBORObject cBORObject3 = map.get(CwtHeaderKeys.ISSUED_AT.INSTANCE.asCBOR());
            if (cBORObject3 != null) {
                CBORObject cBORObject4 = cBORObject3;
                bl2 = false;
                boolean it = false;
                CBORObject it2 = cBORObject4;
                boolean bl5 = false;
                instant = Instant.ofEpochSecond(it2.AsInt64());
            } else {
                instant = null;
            }
            Instant issuedAt = instant;
            CBORObject cBORObject5 = map.get(CwtHeaderKeys.ISSUER.INSTANCE.asCBOR());
            String issuer = cBORObject5 != null ? cBORObject5.AsString() : null;
            CBORObject hcert = map.get(CwtHeaderKeys.HCERT.INSTANCE.asCBOR());
            CBORObject light = map.get(CwtHeaderKeys.LIGHT.INSTANCE.asCBOR());
            if (hcert != null) {
                CBORObject cBORObject6 = hcert.get(keyDccCertV1);
                if (cBORObject6 != null) {
                    CBORObject cBORObject7 = cBORObject6;
                    bl = false;
                    boolean bl6 = false;
                    CBORObject it = cBORObject7;
                    boolean bl7 = false;
                    DccCert dccCert = (DccCert)dccCertAdapter.fromJson(it.ToJSONString());
                    if (dccCert == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)dccCert, (String)"dccCertAdapter.fromJson(\u2026NString()) ?: return null");
                    DccCert dccCert2 = dccCert;
                    return new CertificateHolder(dccCert2, qrCodeData, expirationTime, issuedAt, issuer);
                }
                return null;
            }
            if (light != null) {
                CBORObject cBORObject8 = light.get(keyChLightCertV1);
                if (cBORObject8 != null) {
                    CBORObject cBORObject9 = cBORObject8;
                    bl = false;
                    boolean bl8 = false;
                    CBORObject it = cBORObject9;
                    boolean bl9 = false;
                    ChLightCert chLightCert = (ChLightCert)chLightCertAdapter.fromJson(it.ToJSONString());
                    if (chLightCert == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)chLightCert, (String)"chLightCertAdapter.fromJ\u2026NString()) ?: return null");
                    ChLightCert chLightCert2 = chLightCert;
                    return new CertificateHolder(chLightCert2, qrCodeData, expirationTime, issuedAt, issuer);
                }
                return null;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private CborService() {
    }

    static {
        CborService cborService;
        INSTANCE = cborService = new CborService();
        keyDccCertV1 = CBORObject.FromObject((int)1);
        keyChLightCertV1 = CBORObject.FromObject((int)1);
    }
}

