/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.moderules;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CovidCertificate;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.light.ChLightCert;
import ch.admin.bag.covidcertificate.sdk.core.models.state.ModeValidity;
import ch.admin.bag.covidcertificate.sdk.core.models.state.ModeValidityState;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicData;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicExternalInfo;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicHeaders;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicPayload;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.RuleSet;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.time.Clock;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J2\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0018"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/moderules/ModeRulesVerifier;", "", "()V", "getCertlogicData", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/CertLogicData;", "certificate", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CovidCertificate;", "valueSets", "", "", "", "headers", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/CertLogicHeaders;", "clock", "Ljava/time/Clock;", "getValidityState", "Lch/admin/bag/covidcertificate/sdk/core/models/state/ModeValidityState;", "resultFromModeRule", "Lcom/fasterxml/jackson/databind/JsonNode;", "verify", "Lch/admin/bag/covidcertificate/sdk/core/models/state/ModeValidity;", "ruleSet", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RuleSet;", "mode", "CovidCertificate-SDK-Kotlin"})
public final class ModeRulesVerifier {
    @NotNull
    public final ModeValidity verify(@NotNull CovidCertificate certificate, @NotNull RuleSet ruleSet, @Nullable CertLogicHeaders headers, @NotNull String mode, @NotNull Clock clock) {
        JsonNode ruleLogic;
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)ruleSet, (String)"ruleSet");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        CertLogicData ruleSetData = this.getCertlogicData(certificate, ruleSet.getValueSets(), headers, clock);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        JsonNode jsonNode = ruleLogic = jacksonMapper.readTree(ruleSet.getModeRules().getLogic());
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"ruleLogic");
        JsonNode jsonNode2 = data;
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"data");
        JsonNode resultFromModeRule = CertlogicKt.evaluate(jsonNode, jsonNode2);
        ModeValidityState state = this.getValidityState(resultFromModeRule);
        return new ModeValidity(mode, state);
    }

    public static /* synthetic */ ModeValidity verify$default(ModeRulesVerifier modeRulesVerifier, CovidCertificate covidCertificate, RuleSet ruleSet, CertLogicHeaders certLogicHeaders, String string, Clock clock, int n, Object object) {
        if ((n & 0x10) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        return modeRulesVerifier.verify(covidCertificate, ruleSet, certLogicHeaders, string, clock);
    }

    private final CertLogicData getCertlogicData(CovidCertificate certificate, Map<String, String[]> valueSets, CertLogicHeaders headers, Clock clock) {
        CovidCertificate covidCertificate = certificate;
        CertLogicPayload payload = covidCertificate instanceof ChLightCert ? new CertLogicPayload(null, null, null, headers) : (covidCertificate instanceof DccCert ? new CertLogicPayload(((DccCert)certificate).getPastInfections(), ((DccCert)certificate).getTests(), ((DccCert)certificate).getVaccinations(), headers) : new CertLogicPayload(null, null, null, null));
        String validationClock = ZonedDateTime.now(clock).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String validationClockAtStartOfDay = LocalDate.now(clock).atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String string = validationClock;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"validationClock");
        String string2 = validationClockAtStartOfDay;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"validationClockAtStartOfDay");
        CertLogicExternalInfo externalInfo = new CertLogicExternalInfo(valueSets, string, string2);
        return new CertLogicData(payload, externalInfo);
    }

    static /* synthetic */ CertLogicData getCertlogicData$default(ModeRulesVerifier modeRulesVerifier, CovidCertificate covidCertificate, Map map, CertLogicHeaders certLogicHeaders, Clock clock, int n, Object object) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        return modeRulesVerifier.getCertlogicData(covidCertificate, map, certLogicHeaders, clock);
    }

    private final ModeValidityState getValidityState(JsonNode resultFromModeRule) {
        if (resultFromModeRule instanceof TextNode) {
            String modeValidityState = resultFromModeRule.textValue();
            return StringsKt.equals((String)ModeValidityState.SUCCESS.name(), (String)modeValidityState, (boolean)true) ? ModeValidityState.SUCCESS : (StringsKt.equals((String)ModeValidityState.INVALID.name(), (String)modeValidityState, (boolean)true) ? ModeValidityState.INVALID : (StringsKt.equals((String)ModeValidityState.IS_LIGHT.name(), (String)modeValidityState, (boolean)true) ? ModeValidityState.IS_LIGHT : (StringsKt.equals((String)ModeValidityState.SUCCESS_2G.name(), (String)modeValidityState, (boolean)true) ? ModeValidityState.SUCCESS_2G : (StringsKt.equals((String)ModeValidityState.SUCCESS_2G_PLUS.name(), (String)modeValidityState, (boolean)true) ? ModeValidityState.SUCCESS_2G_PLUS : (StringsKt.equals((String)ModeValidityState.UNKNOWN_MODE.name(), (String)modeValidityState, (boolean)true) ? ModeValidityState.UNKNOWN_MODE : ModeValidityState.UNKNOWN)))));
        }
        return ModeValidityState.UNKNOWN;
    }
}

