/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.models.trustlist;

import ch.admin.bag.covidcertificate.sdk.core.extensions.StringExtensionsKt;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.X5A;
import ch.admin.bag.covidcertificate.sdk.core.utils.CryptoUtil;
import com.squareup.moshi.JsonClass;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=true)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 52\u00020\u0001:\u00015Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J{\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u0004\u0018\u00010/J\t\u00100\u001a\u000201H\u00d6\u0001J\u000e\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020+J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010\u00a8\u00066"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Jwk;", "", "keyId", "", "alg", "use", "x5a", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/X5A;", "x5aS256", "crv", "x", "y", "n", "e", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/X5A;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAlg", "()Ljava/lang/String;", "getCrv", "getE", "getKeyId", "getN", "getUse", "getX", "getX5a", "()Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/X5A;", "getX5aS256", "getY", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "getKeyUsageTypes", "", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "getKid", "", "getPublicKey", "Ljava/security/PublicKey;", "hashCode", "", "isAllowedToSign", "certType", "toString", "Companion", "CovidCertificate-SDK-Kotlin"})
public final class Jwk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String keyId;
    @NotNull
    private final String alg;
    @NotNull
    private final String use;
    @Nullable
    private final X5A x5a;
    @Nullable
    private final String x5aS256;
    @Nullable
    private final String crv;
    @Nullable
    private final String x;
    @Nullable
    private final String y;
    @Nullable
    private final String n;
    @Nullable
    private final String e;
    @NotNull
    private static final String FLAG_USE_ALL = "sig";
    @NotNull
    private static final String ALG_RSA_256 = "RS256";
    @NotNull
    private static final String ALG_ES_256 = "ES256";

    public Jwk(@NotNull String keyId, @NotNull String alg, @NotNull String use, @Nullable X5A x5a, @Nullable String x5aS256, @Nullable String crv, @Nullable String x, @Nullable String y, @Nullable String n, @Nullable String e) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)use, (String)"use");
        this.keyId = keyId;
        this.alg = alg;
        this.use = use;
        this.x5a = x5a;
        this.x5aS256 = x5aS256;
        this.crv = crv;
        this.x = x;
        this.y = y;
        this.n = n;
        this.e = e;
    }

    public /* synthetic */ Jwk(String string, String string2, String string3, X5A x5A, String string4, String string5, String string6, String string7, String string8, String string9, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            x5A = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        if ((n & 0x40) != 0) {
            string6 = null;
        }
        if ((n & 0x80) != 0) {
            string7 = null;
        }
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        if ((n & 0x200) != 0) {
            string9 = null;
        }
        this(string, string2, string3, x5A, string4, string5, string6, string7, string8, string9);
    }

    @NotNull
    public final String getKeyId() {
        return this.keyId;
    }

    @NotNull
    public final String getAlg() {
        return this.alg;
    }

    @NotNull
    public final String getUse() {
        return this.use;
    }

    @Nullable
    public final X5A getX5a() {
        return this.x5a;
    }

    @Nullable
    public final String getX5aS256() {
        return this.x5aS256;
    }

    @Nullable
    public final String getCrv() {
        return this.crv;
    }

    @Nullable
    public final String getX() {
        return this.x;
    }

    @Nullable
    public final String getY() {
        return this.y;
    }

    @Nullable
    public final String getN() {
        return this.n;
    }

    @Nullable
    public final String getE() {
        return this.e;
    }

    @NotNull
    public final byte[] getKid() {
        return StringExtensionsKt.fromBase64(this.keyId);
    }

    @Nullable
    public final PublicKey getPublicKey() {
        try {
            PublicKey publicKey;
            String string = this.alg;
            if (Intrinsics.areEqual((Object)string, (Object)ALG_ES_256)) {
                String string2 = this.x;
                Intrinsics.checkNotNull((Object)string2);
                byte[] byArray = StringExtensionsKt.fromBase64(string2);
                String string3 = this.y;
                Intrinsics.checkNotNull((Object)string3);
                publicKey = CryptoUtil.INSTANCE.ecPublicKeyFromCoordinate(byArray, StringExtensionsKt.fromBase64(string3));
            } else if (Intrinsics.areEqual((Object)string, (Object)ALG_RSA_256)) {
                String string4 = this.n;
                Intrinsics.checkNotNull((Object)string4);
                byte[] byArray = StringExtensionsKt.fromBase64(string4);
                String string5 = this.e;
                Intrinsics.checkNotNull((Object)string5);
                publicKey = CryptoUtil.INSTANCE.rsaPublicKeyFromModulusExponent(byArray, StringExtensionsKt.fromBase64(string5));
            } else {
                publicKey = null;
            }
            return publicKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final boolean isAllowedToSign(@NotNull CertType certType) {
        Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
        return this.getKeyUsageTypes().contains((Object)certType) || Intrinsics.areEqual((Object)this.use, (Object)FLAG_USE_ALL);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CertType> getKeyUsageTypes() {
        void $this$filterTo$iv$iv;
        CertType[] $this$filter$iv = CertType.values();
        boolean $i$f$filter = false;
        CertType[] certTypeArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)this.getUse(), (CharSequence)it.getUse(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String component1() {
        return this.keyId;
    }

    @NotNull
    public final String component2() {
        return this.alg;
    }

    @NotNull
    public final String component3() {
        return this.use;
    }

    @Nullable
    public final X5A component4() {
        return this.x5a;
    }

    @Nullable
    public final String component5() {
        return this.x5aS256;
    }

    @Nullable
    public final String component6() {
        return this.crv;
    }

    @Nullable
    public final String component7() {
        return this.x;
    }

    @Nullable
    public final String component8() {
        return this.y;
    }

    @Nullable
    public final String component9() {
        return this.n;
    }

    @Nullable
    public final String component10() {
        return this.e;
    }

    @NotNull
    public final Jwk copy(@NotNull String keyId, @NotNull String alg, @NotNull String use, @Nullable X5A x5a, @Nullable String x5aS256, @Nullable String crv, @Nullable String x, @Nullable String y, @Nullable String n, @Nullable String e) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)use, (String)"use");
        return new Jwk(keyId, alg, use, x5a, x5aS256, crv, x, y, n, e);
    }

    public static /* synthetic */ Jwk copy$default(Jwk jwk, String string, String string2, String string3, X5A x5A, String string4, String string5, String string6, String string7, String string8, String string9, int n, Object object) {
        if ((n & 1) != 0) {
            string = jwk.keyId;
        }
        if ((n & 2) != 0) {
            string2 = jwk.alg;
        }
        if ((n & 4) != 0) {
            string3 = jwk.use;
        }
        if ((n & 8) != 0) {
            x5A = jwk.x5a;
        }
        if ((n & 0x10) != 0) {
            string4 = jwk.x5aS256;
        }
        if ((n & 0x20) != 0) {
            string5 = jwk.crv;
        }
        if ((n & 0x40) != 0) {
            string6 = jwk.x;
        }
        if ((n & 0x80) != 0) {
            string7 = jwk.y;
        }
        if ((n & 0x100) != 0) {
            string8 = jwk.n;
        }
        if ((n & 0x200) != 0) {
            string9 = jwk.e;
        }
        return jwk.copy(string, string2, string3, x5A, string4, string5, string6, string7, string8, string9);
    }

    @NotNull
    public String toString() {
        return "Jwk(keyId=" + this.keyId + ", alg=" + this.alg + ", use=" + this.use + ", x5a=" + this.x5a + ", x5aS256=" + this.x5aS256 + ", crv=" + this.crv + ", x=" + this.x + ", y=" + this.y + ", n=" + this.n + ", e=" + this.e + ')';
    }

    public int hashCode() {
        int result = this.keyId.hashCode();
        result = result * 31 + this.alg.hashCode();
        result = result * 31 + this.use.hashCode();
        result = result * 31 + (this.x5a == null ? 0 : this.x5a.hashCode());
        result = result * 31 + (this.x5aS256 == null ? 0 : this.x5aS256.hashCode());
        result = result * 31 + (this.crv == null ? 0 : this.crv.hashCode());
        result = result * 31 + (this.x == null ? 0 : this.x.hashCode());
        result = result * 31 + (this.y == null ? 0 : this.y.hashCode());
        result = result * 31 + (this.n == null ? 0 : this.n.hashCode());
        result = result * 31 + (this.e == null ? 0 : this.e.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Jwk)) {
            return false;
        }
        Jwk jwk = (Jwk)other;
        if (!Intrinsics.areEqual((Object)this.keyId, (Object)jwk.keyId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alg, (Object)jwk.alg)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.use, (Object)jwk.use)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.x5a, (Object)jwk.x5a)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.x5aS256, (Object)jwk.x5aS256)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.crv, (Object)jwk.crv)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.x, (Object)jwk.x)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.y, (Object)jwk.y)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.n, (Object)jwk.n)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.e, (Object)jwk.e);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J&\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Jwk$Companion;", "", "()V", "ALG_ES_256", "", "ALG_RSA_256", "FLAG_USE_ALL", "fromNE", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Jwk;", "kid", "n", "e", "use", "fromXY", "x", "y", "CovidCertificate-SDK-Kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Jwk fromNE(@NotNull String kid, @NotNull String n, @NotNull String e, @NotNull String use) {
            Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)use, (String)"use");
            return new Jwk(kid, Jwk.ALG_RSA_256, use, null, null, null, null, null, n, e, 248, null);
        }

        @NotNull
        public final Jwk fromXY(@NotNull String kid, @NotNull String x, @NotNull String y, @NotNull String use) {
            Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Intrinsics.checkNotNullParameter((Object)use, (String)"use");
            return new Jwk(kid, Jwk.ALG_ES_256, use, null, null, null, x, y, null, null, 824, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

