/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules;

import ch.admin.bag.covidcertificate.sdk.core.extensions.TestEntryExtensionsKt;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.TestEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.state.CheckNationalRulesState;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicData;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicExternalInfo;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicHeaders;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.CertLogicPayload;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.DisplayRule;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.Rule;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.RuleSet;
import ch.admin.bag.covidcertificate.sdk.core.utils.DateUtil;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.DisplayValidityCalculator;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.NationalRulesError;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.ValidityRange;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.InternalsKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\\\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J2\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/NationalRulesVerifier;", "", "()V", "displayValidityCalculator", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/DisplayValidityCalculator;", "getCertlogicData", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/CertLogicData;", "dccCert", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/DccCert;", "valueSets", "", "", "", "headers", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/CertLogicHeaders;", "clock", "Ljava/time/Clock;", "getErrorStateForRule", "Lch/admin/bag/covidcertificate/sdk/core/models/state/CheckNationalRulesState;", "rule", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Rule;", "displayRules", "", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/DisplayRule;", "certType", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "getValidityRange", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/ValidityRange;", "data", "Lcom/fasterxml/jackson/databind/JsonNode;", "verify", "ruleSet", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RuleSet;", "CovidCertificate-SDK-Kotlin"})
public final class NationalRulesVerifier {
    @NotNull
    private final DisplayValidityCalculator displayValidityCalculator = new DisplayValidityCalculator();

    @NotNull
    public final CheckNationalRulesState verify(@NotNull DccCert dccCert, @NotNull RuleSet ruleSet, @NotNull CertType certType, @Nullable CertLogicHeaders headers, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Intrinsics.checkNotNullParameter((Object)ruleSet, (String)"ruleSet");
        Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        CertLogicData ruleSetData = this.getCertlogicData(dccCert, ruleSet.getValueSets(), headers, clock);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        for (Rule rule : ruleSet.getRules()) {
            JsonNode ruleLogic = jacksonMapper.readTree(rule.getLogic());
            Intrinsics.checkNotNullExpressionValue((Object)ruleLogic, (String)"ruleLogic");
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
            boolean isSuccessful = InternalsKt.isTruthy(CertlogicKt.evaluate(ruleLogic, data));
            if (isSuccessful) continue;
            return NationalRulesVerifier.getErrorStateForRule$default(this, rule, dccCert, ruleSet.getDisplayRules(), ruleSetData.getExternal().getValueSets(), certType, headers, null, 64, null);
        }
        List<DisplayRule> list = ruleSet.getDisplayRules();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
        ValidityRange validityRange = this.getValidityRange(list, data, certType);
        boolean isOnlyValidInSwitzerland = this.displayValidityCalculator.isOnlyValidInSwitzerland(ruleSet.getDisplayRules(), data);
        String eolBannerIdentifier = this.displayValidityCalculator.getEolBannerIdentifier(ruleSet.getDisplayRules(), data);
        return validityRange != null ? (CheckNationalRulesState)new CheckNationalRulesState.SUCCESS(validityRange, isOnlyValidInSwitzerland, eolBannerIdentifier) : (CheckNationalRulesState)new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, null, 2, null);
    }

    public static /* synthetic */ CheckNationalRulesState verify$default(NationalRulesVerifier nationalRulesVerifier, DccCert dccCert, RuleSet ruleSet, CertType certType, CertLogicHeaders certLogicHeaders, Clock clock, int n, Object object) {
        if ((n & 0x10) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.verify(dccCert, ruleSet, certType, certLogicHeaders, clock);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CertLogicData getCertlogicData(@NotNull DccCert dccCert, @NotNull Map<String, String[]> valueSets, @Nullable CertLogicHeaders headers, @NotNull Clock clock) {
        List list;
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Intrinsics.checkNotNullParameter(valueSets, (String)"valueSets");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        List<TestEntry> list2 = dccCert.getTests();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TestEntry testEntry;
                void it;
                TestEntry testEntry2 = (TestEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (TestEntryExtensionsKt.isPositiveRatTest((TestEntry)it)) {
                    ZonedDateTime zonedDateTime;
                    LocalDateTime localDateTime;
                    LocalDateTime localDateTime2;
                    OffsetTime offsetTime = OffsetDateTime.parse(it.getTimestampSample()).toOffsetTime();
                    String string = it.getTimestampSample();
                    TemporalAccessor temporalAccessor = offsetTime.getOffset();
                    Intrinsics.checkNotNullExpressionValue((Object)temporalAccessor, (String)"offsetTime.offset");
                    LocalDateTime localDateTime3 = DateUtil.INSTANCE.parseDateTime(string, (ZoneId)((Object)temporalAccessor));
                    String string2 = localDateTime3 == null ? null : ((temporalAccessor = localDateTime3.withHour(0)) == null ? null : ((localDateTime2 = ((LocalDateTime)temporalAccessor).withMinute(0)) == null ? null : ((localDateTime = localDateTime2.withSecond(0)) == null ? null : ((zonedDateTime = localDateTime.atZone(ZoneId.systemDefault())) == null ? null : zonedDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)))));
                    String timestampSample = string2 == null ? it.getTimestampSample() : string2;
                    testEntry = TestEntry.copy$default((TestEntry)it, null, null, null, null, timestampSample, null, null, null, null, null, null, 2031, null);
                } else {
                    testEntry = it;
                }
                collection.add(testEntry);
            }
            list = (List)destination$iv$iv;
        }
        List tests = list;
        CertLogicPayload payload = new CertLogicPayload(dccCert.getPastInfections(), tests, dccCert.getVaccinations(), headers);
        String validationClock = ZonedDateTime.now(clock).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String validationClockAtStartOfDay = LocalDate.now(clock).atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)validationClock, (String)"validationClock");
        Intrinsics.checkNotNullExpressionValue((Object)validationClockAtStartOfDay, (String)"validationClockAtStartOfDay");
        CertLogicExternalInfo externalInfo = new CertLogicExternalInfo(valueSets, validationClock, validationClockAtStartOfDay);
        return new CertLogicData(payload, externalInfo);
    }

    public static /* synthetic */ CertLogicData getCertlogicData$default(NationalRulesVerifier nationalRulesVerifier, DccCert dccCert, Map map, CertLogicHeaders certLogicHeaders, Clock clock, int n, Object object) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.getCertlogicData(dccCert, map, certLogicHeaders, clock);
    }

    private final CheckNationalRulesState getErrorStateForRule(Rule rule, DccCert dccCert, List<DisplayRule> displayRules, Map<String, String[]> valueSets, CertType certType, CertLogicHeaders headers, Clock clock) {
        CheckNationalRulesState checkNationalRulesState;
        CertLogicData ruleSetData = this.getCertlogicData(dccCert, valueSets, headers, clock);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        switch (rule.getIdentifier()) {
            case "GR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_DISEASE_TARGET, rule.getIdentifier());
                break;
            }
            case "VR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_VACCINE_ENTRIES, rule.getIdentifier());
                break;
            }
            case "VR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NOT_FULLY_PROTECTED, rule.getIdentifier());
                break;
            }
            case "VR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getIdentifier());
                break;
            }
            case "VR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "VR-CH-0004": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID2 = nOT_YET_VALID;
                if (nOT_YET_VALID2 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID2;
                break;
            }
            case "VR-CH-0005": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID3 = nOT_YET_VALID;
                if (nOT_YET_VALID3 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID3;
                break;
            }
            case "VR-CH-0006": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE2 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE2 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE2;
                break;
            }
            case "VR-CH-0007": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE3 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE3 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE3;
                break;
            }
            case "VR-CH-0008": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE4 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE4 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE4;
                break;
            }
            case "TR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_TEST_ENTRIES, rule.getIdentifier());
                break;
            }
            case "TR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.POSITIVE_RESULT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_TEST_TYPE, rule.getIdentifier());
                break;
            }
            case "TR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0004": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "TR-CH-0005": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID4 = nOT_YET_VALID;
                if (nOT_YET_VALID4 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID4;
                break;
            }
            case "TR-CH-0006": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE5 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE5 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE5;
                break;
            }
            case "TR-CH-0007": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE6 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE6 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE6;
                break;
            }
            case "TR-CH-0008": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NEGATIVE_RESULT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0009": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE7 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE7 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE7;
                break;
            }
            case "TR-CH-0010": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE8 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE8 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE8;
                break;
            }
            case "TR-CH-0011": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID5 = nOT_YET_VALID;
                if (nOT_YET_VALID5 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID5;
                break;
            }
            case "TR-CH-0012": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE9 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE9 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE9;
                break;
            }
            case "RR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_RECOVERY_ENTRIES, rule.getIdentifier());
                break;
            }
            case "RR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "RR-CH-0002": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID6 = nOT_YET_VALID;
                if (nOT_YET_VALID6 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID6;
                break;
            }
            case "RR-CH-0003": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE10 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE10 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE10;
                break;
            }
            default: {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.UNKNOWN_RULE_FAILED, rule.getIdentifier());
            }
        }
        return checkNationalRulesState;
    }

    static /* synthetic */ CheckNationalRulesState getErrorStateForRule$default(NationalRulesVerifier nationalRulesVerifier, Rule rule, DccCert dccCert, List list, Map map, CertType certType, CertLogicHeaders certLogicHeaders, Clock clock, int n, Object object) {
        if ((n & 0x40) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.getErrorStateForRule(rule, dccCert, list, map, certType, certLogicHeaders, clock);
    }

    private final ValidityRange getValidityRange(List<DisplayRule> displayRules, JsonNode data, CertType certType) {
        return this.displayValidityCalculator.getDisplayValidityRangeForSystemTimeZone(displayRules, data, certType);
    }
}

